/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="portX")
    private final Integer portX;
    @JsonProperty(value="modes")
    private final List<Modes> modes;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusDetails")
    private final String statusDetails;
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="resourceId")
    private final String resourceId;

    @Deprecated
    @ConstructorProperties(value={"hostname", "ipAddress", "port", "portX", "modes", "status", "statusDetails", "resourceType", "resourceId"})
    public DbSystemEndpoint(String hostname, String ipAddress, Integer port, Integer portX, List<Modes> modes, Status status, String statusDetails, ResourceType resourceType, String resourceId) {
        this.hostname = hostname;
        this.ipAddress = ipAddress;
        this.port = port;
        this.portX = portX;
        this.modes = modes;
        this.status = status;
        this.statusDetails = statusDetails;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getPortX() {
        return this.portX;
    }

    public List<Modes> getModes() {
        return this.modes;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", portX=").append(String.valueOf(this.portX));
        sb.append(", modes=").append(String.valueOf(this.modes));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDetails=").append(String.valueOf(this.statusDetails));
        sb.append(", resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemEndpoint)) {
            return false;
        }
        DbSystemEndpoint other = (DbSystemEndpoint)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.port, other.port) && Objects.equals(this.portX, other.portX) && Objects.equals(this.modes, other.modes) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusDetails, other.statusDetails) && Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.resourceId, other.resourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.portX == null ? 43 : this.portX.hashCode());
        result = result * 59 + (this.modes == null ? 43 : this.modes.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDetails == null ? 43 : this.statusDetails.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        Dbsystem("DBSYSTEM"),
        ReadReplica("READ_REPLICA"),
        LoadBalancer("LOAD_BALANCER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Modes implements BmcEnum
    {
        Read("READ"),
        Write("WRITE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Modes> map;

        private Modes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Modes create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Modes', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Modes.class);
            map = new HashMap<String, Modes>();
            for (Modes v : Modes.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="portX")
        private Integer portX;
        @JsonProperty(value="modes")
        private List<Modes> modes;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusDetails")
        private String statusDetails;
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder portX(Integer portX) {
            this.portX = portX;
            this.__explicitlySet__.add("portX");
            return this;
        }

        public Builder modes(List<Modes> modes) {
            this.modes = modes;
            this.__explicitlySet__.add("modes");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public DbSystemEndpoint build() {
            DbSystemEndpoint model = new DbSystemEndpoint(this.hostname, this.ipAddress, this.port, this.portX, this.modes, this.status, this.statusDetails, this.resourceType, this.resourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemEndpoint model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("portX")) {
                this.portX(model.getPortX());
            }
            if (model.wasPropertyExplicitlySet("modes")) {
                this.modes(model.getModes());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDetails")) {
                this.statusDetails(model.getStatusDetails());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            return this;
        }
    }
}

