/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.mysql.model.ChannelFilter;
import com.oracle.bmc.mysql.model.ChannelTarget;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="targetType")
@JsonFilter(value="explicitlySetFilter")
public final class ChannelTargetDbSystem
extends ChannelTarget {
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="channelName")
    private final String channelName;
    @JsonProperty(value="applierUsername")
    private final String applierUsername;
    @JsonProperty(value="filters")
    private final List<ChannelFilter> filters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ChannelTargetDbSystem(String dbSystemId, String channelName, String applierUsername, List<ChannelFilter> filters) {
        this.dbSystemId = dbSystemId;
        this.channelName = channelName;
        this.applierUsername = applierUsername;
        this.filters = filters;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getApplierUsername() {
        return this.applierUsername;
    }

    public List<ChannelFilter> getFilters() {
        return this.filters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChannelTargetDbSystem(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", channelName=").append(String.valueOf(this.channelName));
        sb.append(", applierUsername=").append(String.valueOf(this.applierUsername));
        sb.append(", filters=").append(String.valueOf(this.filters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelTargetDbSystem)) {
            return false;
        }
        ChannelTargetDbSystem other = (ChannelTargetDbSystem)((Object)o);
        return Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.channelName, other.channelName) && Objects.equals(this.applierUsername, other.applierUsername) && Objects.equals(this.filters, other.filters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.channelName == null ? 43 : this.channelName.hashCode());
        result = result * 59 + (this.applierUsername == null ? 43 : this.applierUsername.hashCode());
        result = result * 59 + (this.filters == null ? 43 : this.filters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="channelName")
        private String channelName;
        @JsonProperty(value="applierUsername")
        private String applierUsername;
        @JsonProperty(value="filters")
        private List<ChannelFilter> filters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder channelName(String channelName) {
            this.channelName = channelName;
            this.__explicitlySet__.add("channelName");
            return this;
        }

        public Builder applierUsername(String applierUsername) {
            this.applierUsername = applierUsername;
            this.__explicitlySet__.add("applierUsername");
            return this;
        }

        public Builder filters(List<ChannelFilter> filters) {
            this.filters = filters;
            this.__explicitlySet__.add("filters");
            return this;
        }

        public ChannelTargetDbSystem build() {
            ChannelTargetDbSystem model = new ChannelTargetDbSystem(this.dbSystemId, this.channelName, this.applierUsername, this.filters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChannelTargetDbSystem model) {
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("channelName")) {
                this.channelName(model.getChannelName());
            }
            if (model.wasPropertyExplicitlySet("applierUsername")) {
                this.applierUsername(model.getApplierUsername());
            }
            if (model.wasPropertyExplicitlySet("filters")) {
                this.filters(model.getFilters());
            }
            return this;
        }
    }
}

