/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.mysql.Replicas;
import com.oracle.bmc.mysql.model.Replica;
import com.oracle.bmc.mysql.requests.GetReplicaRequest;
import com.oracle.bmc.mysql.responses.GetReplicaResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ReplicasWaiters {
    private final ExecutorService executorService;
    private final Replicas client;

    public ReplicasWaiters(ExecutorService executorService, Replicas client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetReplicaRequest, GetReplicaResponse> forReplica(GetReplicaRequest request, Replica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forReplica(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetReplicaRequest, GetReplicaResponse> forReplica(GetReplicaRequest request, Replica.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetReplicaRequest, GetReplicaResponse> forReplica(GetReplicaRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Replica.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forReplica(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetReplicaRequest, GetReplicaResponse> forReplica(BmcGenericWaiter waiter, GetReplicaRequest request, Replica.LifecycleState ... targetStates) {
        final HashSet<Replica.LifecycleState> targetStatesSet = new HashSet<Replica.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetReplicaRequest, GetReplicaResponse>(){

            @Override
            public GetReplicaResponse apply(GetReplicaRequest request) {
                return ReplicasWaiters.this.client.getReplica(request);
            }
        }, (Predicate)new Predicate<GetReplicaResponse>(){

            @Override
            public boolean test(GetReplicaResponse response) {
                return targetStatesSet.contains((Object)response.getReplica().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Replica.LifecycleState.Deleted)), (Object)request);
    }
}

