/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.mysql.DbSystemAsync;
import com.oracle.bmc.mysql.model.AnalyticsCluster;
import com.oracle.bmc.mysql.model.AnalyticsClusterMemoryEstimate;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.mysql.model.DbSystemSummary;
import com.oracle.bmc.mysql.model.HeatWaveCluster;
import com.oracle.bmc.mysql.model.HeatWaveClusterMemoryEstimate;
import com.oracle.bmc.mysql.requests.AddAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.AddHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.CreateDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.DeleteDbSystemRequest;
import com.oracle.bmc.mysql.requests.DeleteHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.GenerateAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GenerateHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.GetDbSystemRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterMemoryEstimateRequest;
import com.oracle.bmc.mysql.requests.GetHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.ListDbSystemsRequest;
import com.oracle.bmc.mysql.requests.RestartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.RestartDbSystemRequest;
import com.oracle.bmc.mysql.requests.RestartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StartAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StartDbSystemRequest;
import com.oracle.bmc.mysql.requests.StartHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.StopAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.StopDbSystemRequest;
import com.oracle.bmc.mysql.requests.StopHeatWaveClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateAnalyticsClusterRequest;
import com.oracle.bmc.mysql.requests.UpdateDbSystemRequest;
import com.oracle.bmc.mysql.requests.UpdateHeatWaveClusterRequest;
import com.oracle.bmc.mysql.responses.AddAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.AddHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.CreateDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.DeleteDbSystemResponse;
import com.oracle.bmc.mysql.responses.DeleteHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.GenerateAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GenerateHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.GetDbSystemResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterMemoryEstimateResponse;
import com.oracle.bmc.mysql.responses.GetHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.ListDbSystemsResponse;
import com.oracle.bmc.mysql.responses.RestartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.RestartDbSystemResponse;
import com.oracle.bmc.mysql.responses.RestartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StartAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StartDbSystemResponse;
import com.oracle.bmc.mysql.responses.StartHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.StopAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.StopDbSystemResponse;
import com.oracle.bmc.mysql.responses.StopHeatWaveClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateAnalyticsClusterResponse;
import com.oracle.bmc.mysql.responses.UpdateDbSystemResponse;
import com.oracle.bmc.mysql.responses.UpdateHeatWaveClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSystemAsyncClient
extends BaseAsyncClient
implements DbSystemAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBSYSTEM").serviceEndpointPrefix("").serviceEndpointTemplate("https://mysql.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbSystemAsyncClient.class);

    private DbSystemAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddAnalyticsClusterResponse> addAnalyticsCluster(AddAnalyticsClusterRequest request, AsyncHandler<AddAnalyticsClusterRequest, AddAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddAnalyticsClusterDetails(), "addAnalyticsClusterDetails is required");
        return this.clientCall(request, AddAnalyticsClusterResponse::builder).logger(LOG, "addAnalyticsCluster").serviceDetails("DbSystem", "AddAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/AddAnalyticsCluster").method(Method.POST).requestBuilder(AddAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").appendPathParam("actions").appendPathParam("add").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AnalyticsCluster.class, AddAnalyticsClusterResponse.Builder::analyticsCluster).handleResponseHeaderString("etag", AddAnalyticsClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<AddHeatWaveClusterResponse> addHeatWaveCluster(AddHeatWaveClusterRequest request, AsyncHandler<AddHeatWaveClusterRequest, AddHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddHeatWaveClusterDetails(), "addHeatWaveClusterDetails is required");
        return this.clientCall(request, AddHeatWaveClusterResponse::builder).logger(LOG, "addHeatWaveCluster").serviceDetails("DbSystem", "AddHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/AddHeatWaveCluster").method(Method.POST).requestBuilder(AddHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("add").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(HeatWaveCluster.class, AddHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", AddHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AddHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDbSystemResponse> createDbSystem(CreateDbSystemRequest request, AsyncHandler<CreateDbSystemRequest, CreateDbSystemResponse> handler) {
        Objects.requireNonNull(request.getCreateDbSystemDetails(), "createDbSystemDetails is required");
        return this.clientCall(request, CreateDbSystemResponse::builder).logger(LOG, "createDbSystem").serviceDetails("DbSystem", "CreateDbSystem", "").method(Method.POST).requestBuilder(CreateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DbSystem.class, CreateDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", CreateDbSystemResponse.Builder::etag).handleResponseHeaderString("location", CreateDbSystemResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAnalyticsClusterResponse> deleteAnalyticsCluster(DeleteAnalyticsClusterRequest request, AsyncHandler<DeleteAnalyticsClusterRequest, DeleteAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAnalyticsClusterResponse::builder).logger(LOG, "deleteAnalyticsCluster").serviceDetails("DbSystem", "DeleteAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/DeleteAnalyticsCluster").method(Method.DELETE).requestBuilder(DeleteAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDbSystemResponse> deleteDbSystem(DeleteDbSystemRequest request, AsyncHandler<DeleteDbSystemRequest, DeleteDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDbSystemResponse::builder).logger(LOG, "deleteDbSystem").serviceDetails("DbSystem", "DeleteDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/DeleteDbSystem").method(Method.DELETE).requestBuilder(DeleteDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteHeatWaveClusterResponse> deleteHeatWaveCluster(DeleteHeatWaveClusterRequest request, AsyncHandler<DeleteHeatWaveClusterRequest, DeleteHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteHeatWaveClusterResponse::builder).logger(LOG, "deleteHeatWaveCluster").serviceDetails("DbSystem", "DeleteHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/DeleteHeatWaveCluster").method(Method.DELETE).requestBuilder(DeleteHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateAnalyticsClusterMemoryEstimateResponse> generateAnalyticsClusterMemoryEstimate(GenerateAnalyticsClusterMemoryEstimateRequest request, AsyncHandler<GenerateAnalyticsClusterMemoryEstimateRequest, GenerateAnalyticsClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateAnalyticsClusterMemoryEstimateResponse::builder).logger(LOG, "generateAnalyticsClusterMemoryEstimate").serviceDetails("DbSystem", "GenerateAnalyticsClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsClusterMemoryEstimate/GenerateAnalyticsClusterMemoryEstimate").method(Method.POST).requestBuilder(GenerateAnalyticsClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsClusterMemoryEstimate").appendPathParam("actions").appendPathParam("generate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(AnalyticsClusterMemoryEstimate.class, GenerateAnalyticsClusterMemoryEstimateResponse.Builder::analyticsClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GenerateAnalyticsClusterMemoryEstimateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GenerateAnalyticsClusterMemoryEstimateResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateHeatWaveClusterMemoryEstimateResponse> generateHeatWaveClusterMemoryEstimate(GenerateHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GenerateHeatWaveClusterMemoryEstimateRequest, GenerateHeatWaveClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "generateHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GenerateHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GenerateHeatWaveClusterMemoryEstimate").method(Method.POST).requestBuilder(GenerateHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").appendPathParam("actions").appendPathParam("generate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(HeatWaveClusterMemoryEstimate.class, GenerateHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", GenerateHeatWaveClusterMemoryEstimateResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAnalyticsClusterResponse> getAnalyticsCluster(GetAnalyticsClusterRequest request, AsyncHandler<GetAnalyticsClusterRequest, GetAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAnalyticsClusterResponse::builder).logger(LOG, "getAnalyticsCluster").serviceDetails("DbSystem", "GetAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/GetAnalyticsCluster").method(Method.GET).requestBuilder(GetAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(AnalyticsCluster.class, GetAnalyticsClusterResponse.Builder::analyticsCluster).handleResponseHeaderString("etag", GetAnalyticsClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnalyticsClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAnalyticsClusterMemoryEstimateResponse> getAnalyticsClusterMemoryEstimate(GetAnalyticsClusterMemoryEstimateRequest request, AsyncHandler<GetAnalyticsClusterMemoryEstimateRequest, GetAnalyticsClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAnalyticsClusterMemoryEstimateResponse::builder).logger(LOG, "getAnalyticsClusterMemoryEstimate").serviceDetails("DbSystem", "GetAnalyticsClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsClusterMemoryEstimate/GetAnalyticsClusterMemoryEstimate").method(Method.GET).requestBuilder(GetAnalyticsClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsClusterMemoryEstimate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnalyticsClusterMemoryEstimate.class, GetAnalyticsClusterMemoryEstimateResponse.Builder::analyticsClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GetAnalyticsClusterMemoryEstimateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request, AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDbSystemResponse::builder).logger(LOG, "getDbSystem").serviceDetails("DbSystem", "GetDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/GetDbSystem").method(Method.GET).requestBuilder(GetDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(DbSystem.class, GetDbSystemResponse.Builder::dbSystem).handleResponseHeaderString("etag", GetDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHeatWaveClusterResponse> getHeatWaveCluster(GetHeatWaveClusterRequest request, AsyncHandler<GetHeatWaveClusterRequest, GetHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHeatWaveClusterResponse::builder).logger(LOG, "getHeatWaveCluster").serviceDetails("DbSystem", "GetHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/GetHeatWaveCluster").method(Method.GET).requestBuilder(GetHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(HeatWaveCluster.class, GetHeatWaveClusterResponse.Builder::heatWaveCluster).handleResponseHeaderString("etag", GetHeatWaveClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHeatWaveClusterMemoryEstimateResponse> getHeatWaveClusterMemoryEstimate(GetHeatWaveClusterMemoryEstimateRequest request, AsyncHandler<GetHeatWaveClusterMemoryEstimateRequest, GetHeatWaveClusterMemoryEstimateResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHeatWaveClusterMemoryEstimateResponse::builder).logger(LOG, "getHeatWaveClusterMemoryEstimate").serviceDetails("DbSystem", "GetHeatWaveClusterMemoryEstimate", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveClusterMemoryEstimate/GetHeatWaveClusterMemoryEstimate").method(Method.GET).requestBuilder(GetHeatWaveClusterMemoryEstimateRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveClusterMemoryEstimate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HeatWaveClusterMemoryEstimate.class, GetHeatWaveClusterMemoryEstimateResponse.Builder::heatWaveClusterMemoryEstimate).handleResponseHeaderString("opc-request-id", GetHeatWaveClusterMemoryEstimateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request, AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDbSystemsResponse::builder).logger(LOG, "listDbSystems").serviceDetails("DbSystem", "ListDbSystems", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystemSummary/ListDbSystems").method(Method.GET).requestBuilder(ListDbSystemsRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendQueryParam("isAnalyticsClusterAttached", (Object)request.getIsAnalyticsClusterAttached()).appendQueryParam("isHeatWaveClusterAttached", (Object)request.getIsHeatWaveClusterAttached()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dbSystemId", (Object)request.getDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("configurationId", (Object)request.getConfigurationId()).appendQueryParam("isUpToDate", (Object)request.getIsUpToDate()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DbSystemSummary.class, ListDbSystemsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListDbSystemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbSystemsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RestartAnalyticsClusterResponse> restartAnalyticsCluster(RestartAnalyticsClusterRequest request, AsyncHandler<RestartAnalyticsClusterRequest, RestartAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RestartAnalyticsClusterResponse::builder).logger(LOG, "restartAnalyticsCluster").serviceDetails("DbSystem", "RestartAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/RestartAnalyticsCluster").method(Method.POST).requestBuilder(RestartAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RestartAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RestartDbSystemResponse> restartDbSystem(RestartDbSystemRequest request, AsyncHandler<RestartDbSystemRequest, RestartDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestartDbSystemDetails(), "restartDbSystemDetails is required");
        return this.clientCall(request, RestartDbSystemResponse::builder).logger(LOG, "restartDbSystem").serviceDetails("DbSystem", "RestartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/RestartDbSystem").method(Method.POST).requestBuilder(RestartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RestartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<RestartHeatWaveClusterResponse> restartHeatWaveCluster(RestartHeatWaveClusterRequest request, AsyncHandler<RestartHeatWaveClusterRequest, RestartHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RestartHeatWaveClusterResponse::builder).logger(LOG, "restartHeatWaveCluster").serviceDetails("DbSystem", "RestartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/RestartHeatWaveCluster").method(Method.POST).requestBuilder(RestartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("restart").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RestartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestartHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartAnalyticsClusterResponse> startAnalyticsCluster(StartAnalyticsClusterRequest request, AsyncHandler<StartAnalyticsClusterRequest, StartAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartAnalyticsClusterResponse::builder).logger(LOG, "startAnalyticsCluster").serviceDetails("DbSystem", "StartAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/StartAnalyticsCluster").method(Method.POST).requestBuilder(StartAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartDbSystemResponse> startDbSystem(StartDbSystemRequest request, AsyncHandler<StartDbSystemRequest, StartDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartDbSystemResponse::builder).logger(LOG, "startDbSystem").serviceDetails("DbSystem", "StartDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StartDbSystem").method(Method.POST).requestBuilder(StartDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartHeatWaveClusterResponse> startHeatWaveCluster(StartHeatWaveClusterRequest request, AsyncHandler<StartHeatWaveClusterRequest, StartHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartHeatWaveClusterResponse::builder).logger(LOG, "startHeatWaveCluster").serviceDetails("DbSystem", "StartHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StartHeatWaveCluster").method(Method.POST).requestBuilder(StartHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopAnalyticsClusterResponse> stopAnalyticsCluster(StopAnalyticsClusterRequest request, AsyncHandler<StopAnalyticsClusterRequest, StopAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopAnalyticsClusterResponse::builder).logger(LOG, "stopAnalyticsCluster").serviceDetails("DbSystem", "StopAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/StopAnalyticsCluster").method(Method.POST).requestBuilder(StopAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopDbSystemResponse> stopDbSystem(StopDbSystemRequest request, AsyncHandler<StopDbSystemRequest, StopDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStopDbSystemDetails(), "stopDbSystemDetails is required");
        return this.clientCall(request, StopDbSystemResponse::builder).logger(LOG, "stopDbSystem").serviceDetails("DbSystem", "StopDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/StopDbSystem").method(Method.POST).requestBuilder(StopDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", StopDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopHeatWaveClusterResponse> stopHeatWaveCluster(StopHeatWaveClusterRequest request, AsyncHandler<StopHeatWaveClusterRequest, StopHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopHeatWaveClusterResponse::builder).logger(LOG, "stopHeatWaveCluster").serviceDetails("DbSystem", "StopHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/StopHeatWaveCluster").method(Method.POST).requestBuilder(StopHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAnalyticsClusterResponse> updateAnalyticsCluster(UpdateAnalyticsClusterRequest request, AsyncHandler<UpdateAnalyticsClusterRequest, UpdateAnalyticsClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnalyticsClusterDetails(), "updateAnalyticsClusterDetails is required");
        return this.clientCall(request, UpdateAnalyticsClusterResponse::builder).logger(LOG, "updateAnalyticsCluster").serviceDetails("DbSystem", "UpdateAnalyticsCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/AnalyticsCluster/UpdateAnalyticsCluster").method(Method.PUT).requestBuilder(UpdateAnalyticsClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("analyticsCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateAnalyticsClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAnalyticsClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request, AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbSystemDetails(), "updateDbSystemDetails is required");
        return this.clientCall(request, UpdateDbSystemResponse::builder).logger(LOG, "updateDbSystem").serviceDetails("DbSystem", "UpdateDbSystem", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/DbSystem/UpdateDbSystem").method(Method.PUT).requestBuilder(UpdateDbSystemRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHeatWaveClusterResponse> updateHeatWaveCluster(UpdateHeatWaveClusterRequest request, AsyncHandler<UpdateHeatWaveClusterRequest, UpdateHeatWaveClusterResponse> handler) {
        Validate.notBlank((String)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHeatWaveClusterDetails(), "updateHeatWaveClusterDetails is required");
        return this.clientCall(request, UpdateHeatWaveClusterResponse::builder).logger(LOG, "updateHeatWaveCluster").serviceDetails("DbSystem", "UpdateHeatWaveCluster", "https://docs.oracle.com/iaas/api/#/en/mysql/20190415/HeatWaveCluster/UpdateHeatWaveCluster").method(Method.PUT).requestBuilder(UpdateHeatWaveClusterRequest::builder).basePath("/20190415").appendPathParam("dbSystems").appendPathParam(request.getDbSystemId()).appendPathParam("heatWaveCluster").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateHeatWaveClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHeatWaveClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbSystemAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbSystemAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DbSystemAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbSystemAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbSystemAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbSystemAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbSystemAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

