/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.managementdashboard.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetManagementSavedSearchRequest
extends BmcRequest<Void> {
    private String managementSavedSearchId;
    private String opcRetryToken;
    private String opcRequestId;

    public String getManagementSavedSearchId() {
        return this.managementSavedSearchId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managementSavedSearchId(this.managementSavedSearchId).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managementSavedSearchId=").append(String.valueOf(this.managementSavedSearchId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagementSavedSearchRequest)) {
            return false;
        }
        GetManagementSavedSearchRequest other = (GetManagementSavedSearchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managementSavedSearchId, other.managementSavedSearchId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managementSavedSearchId == null ? 43 : this.managementSavedSearchId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagementSavedSearchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managementSavedSearchId = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder managementSavedSearchId(String managementSavedSearchId) {
            this.managementSavedSearchId = managementSavedSearchId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagementSavedSearchRequest o) {
            this.managementSavedSearchId(o.getManagementSavedSearchId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagementSavedSearchRequest build() {
            GetManagementSavedSearchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetManagementSavedSearchRequest buildWithoutInvocationCallback() {
            GetManagementSavedSearchRequest request = new GetManagementSavedSearchRequest();
            request.managementSavedSearchId = this.managementSavedSearchId;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

