/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.logging.model.ChangeLogGroupCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeLogGroupCompartmentRequest
extends BmcRequest<ChangeLogGroupCompartmentDetails> {
    private String logGroupId;
    private ChangeLogGroupCompartmentDetails changeLogGroupCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public ChangeLogGroupCompartmentDetails getChangeLogGroupCompartmentDetails() {
        return this.changeLogGroupCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeLogGroupCompartmentDetails getBody$() {
        return this.changeLogGroupCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().logGroupId(this.logGroupId).changeLogGroupCompartmentDetails(this.changeLogGroupCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",changeLogGroupCompartmentDetails=").append(String.valueOf((Object)this.changeLogGroupCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeLogGroupCompartmentRequest)) {
            return false;
        }
        ChangeLogGroupCompartmentRequest other = (ChangeLogGroupCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals((Object)this.changeLogGroupCompartmentDetails, (Object)other.changeLogGroupCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.changeLogGroupCompartmentDetails == null ? 43 : this.changeLogGroupCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeLogGroupCompartmentRequest, ChangeLogGroupCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String logGroupId = null;
        private ChangeLogGroupCompartmentDetails changeLogGroupCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder changeLogGroupCompartmentDetails(ChangeLogGroupCompartmentDetails changeLogGroupCompartmentDetails) {
            this.changeLogGroupCompartmentDetails = changeLogGroupCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeLogGroupCompartmentRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.changeLogGroupCompartmentDetails(o.getChangeLogGroupCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeLogGroupCompartmentRequest build() {
            ChangeLogGroupCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeLogGroupCompartmentDetails body) {
            this.changeLogGroupCompartmentDetails(body);
            return this;
        }

        public ChangeLogGroupCompartmentRequest buildWithoutInvocationCallback() {
            ChangeLogGroupCompartmentRequest request = new ChangeLogGroupCompartmentRequest();
            request.logGroupId = this.logGroupId;
            request.changeLogGroupCompartmentDetails = this.changeLogGroupCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

