/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.logging.model.GroupAssociationDetails;
import com.oracle.bmc.logging.model.LogLifecycleState;
import com.oracle.bmc.logging.model.UnifiedAgentServiceConfigurationDetails;
import com.oracle.bmc.logging.model.UnifiedAgentServiceConfigurationStates;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedAgentConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="lifecycleState")
    private final LogLifecycleState lifecycleState;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="configurationState")
    private final UnifiedAgentServiceConfigurationStates configurationState;
    @JsonProperty(value="serviceConfiguration")
    private final UnifiedAgentServiceConfigurationDetails serviceConfiguration;
    @JsonProperty(value="groupAssociation")
    private final GroupAssociationDetails groupAssociation;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "definedTags", "freeformTags", "timeCreated", "timeLastModified", "lifecycleState", "isEnabled", "configurationState", "serviceConfiguration", "groupAssociation"})
    public UnifiedAgentConfiguration(String id, String compartmentId, String displayName, String description, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Date timeCreated, Date timeLastModified, LogLifecycleState lifecycleState, Boolean isEnabled, UnifiedAgentServiceConfigurationStates configurationState, UnifiedAgentServiceConfigurationDetails serviceConfiguration, GroupAssociationDetails groupAssociation) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.timeCreated = timeCreated;
        this.timeLastModified = timeLastModified;
        this.lifecycleState = lifecycleState;
        this.isEnabled = isEnabled;
        this.configurationState = configurationState;
        this.serviceConfiguration = serviceConfiguration;
        this.groupAssociation = groupAssociation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public LogLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public UnifiedAgentServiceConfigurationStates getConfigurationState() {
        return this.configurationState;
    }

    public UnifiedAgentServiceConfigurationDetails getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public GroupAssociationDetails getGroupAssociation() {
        return this.groupAssociation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UnifiedAgentConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", configurationState=").append(String.valueOf((Object)this.configurationState));
        sb.append(", serviceConfiguration=").append(String.valueOf((Object)this.serviceConfiguration));
        sb.append(", groupAssociation=").append(String.valueOf((Object)this.groupAssociation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnifiedAgentConfiguration)) {
            return false;
        }
        UnifiedAgentConfiguration other = (UnifiedAgentConfiguration)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastModified, other.timeLastModified) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.configurationState, (Object)other.configurationState) && Objects.equals((Object)this.serviceConfiguration, (Object)other.serviceConfiguration) && Objects.equals((Object)this.groupAssociation, (Object)other.groupAssociation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.configurationState == null ? 43 : this.configurationState.hashCode());
        result = result * 59 + (this.serviceConfiguration == null ? 43 : this.serviceConfiguration.hashCode());
        result = result * 59 + (this.groupAssociation == null ? 43 : this.groupAssociation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="lifecycleState")
        private LogLifecycleState lifecycleState;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="configurationState")
        private UnifiedAgentServiceConfigurationStates configurationState;
        @JsonProperty(value="serviceConfiguration")
        private UnifiedAgentServiceConfigurationDetails serviceConfiguration;
        @JsonProperty(value="groupAssociation")
        private GroupAssociationDetails groupAssociation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder lifecycleState(LogLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder configurationState(UnifiedAgentServiceConfigurationStates configurationState) {
            this.configurationState = configurationState;
            this.__explicitlySet__.add("configurationState");
            return this;
        }

        public Builder serviceConfiguration(UnifiedAgentServiceConfigurationDetails serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            this.__explicitlySet__.add("serviceConfiguration");
            return this;
        }

        public Builder groupAssociation(GroupAssociationDetails groupAssociation) {
            this.groupAssociation = groupAssociation;
            this.__explicitlySet__.add("groupAssociation");
            return this;
        }

        public UnifiedAgentConfiguration build() {
            UnifiedAgentConfiguration model = new UnifiedAgentConfiguration(this.id, this.compartmentId, this.displayName, this.description, this.definedTags, this.freeformTags, this.timeCreated, this.timeLastModified, this.lifecycleState, this.isEnabled, this.configurationState, this.serviceConfiguration, this.groupAssociation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UnifiedAgentConfiguration model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("configurationState")) {
                this.configurationState(model.getConfigurationState());
            }
            if (model.wasPropertyExplicitlySet("serviceConfiguration")) {
                this.serviceConfiguration(model.getServiceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("groupAssociation")) {
                this.groupAssociation(model.getGroupAssociation());
            }
            return this;
        }
    }
}

