/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.responses;

import com.oracle.bmc.loganalytics.model.StorageWorkRequest;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetStorageWorkRequestResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private Float retryAfter;
    private StorageWorkRequest storageWorkRequest;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public StorageWorkRequest getStorageWorkRequest() {
        return this.storageWorkRequest;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "retryAfter", "storageWorkRequest"})
    private GetStorageWorkRequestResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, Float retryAfter, StorageWorkRequest storageWorkRequest) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.retryAfter = retryAfter;
        this.storageWorkRequest = storageWorkRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",retryAfter=").append(String.valueOf(this.retryAfter));
        sb.append(",storageWorkRequest=").append(String.valueOf((Object)this.storageWorkRequest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStorageWorkRequestResponse)) {
            return false;
        }
        GetStorageWorkRequestResponse other = (GetStorageWorkRequestResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.retryAfter, other.retryAfter) && Objects.equals((Object)this.storageWorkRequest, (Object)other.storageWorkRequest);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.retryAfter == null ? 43 : this.retryAfter.hashCode());
        result = result * 59 + (this.storageWorkRequest == null ? 43 : this.storageWorkRequest.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetStorageWorkRequestResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private Float retryAfter;
        private StorageWorkRequest storageWorkRequest;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder storageWorkRequest(StorageWorkRequest storageWorkRequest) {
            this.storageWorkRequest = storageWorkRequest;
            return this;
        }

        public Builder copy(GetStorageWorkRequestResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.retryAfter(o.getRetryAfter());
            this.storageWorkRequest(o.getStorageWorkRequest());
            return this;
        }

        public GetStorageWorkRequestResponse build() {
            return new GetStorageWorkRequestResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.retryAfter, this.storageWorkRequest);
        }
    }
}

