/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.TestParserPayloadDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TestParserRequest
extends BmcRequest<TestParserPayloadDetails> {
    private String namespaceName;
    private TestParserPayloadDetails testParserPayloadDetails;
    private Scope scope;
    private String reqOriginModule;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public TestParserPayloadDetails getTestParserPayloadDetails() {
        return this.testParserPayloadDetails;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getReqOriginModule() {
        return this.reqOriginModule;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public TestParserPayloadDetails getBody$() {
        return this.testParserPayloadDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).testParserPayloadDetails(this.testParserPayloadDetails).scope(this.scope).reqOriginModule(this.reqOriginModule).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",testParserPayloadDetails=").append(String.valueOf((Object)this.testParserPayloadDetails));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",reqOriginModule=").append(String.valueOf(this.reqOriginModule));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestParserRequest)) {
            return false;
        }
        TestParserRequest other = (TestParserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.testParserPayloadDetails, (Object)other.testParserPayloadDetails) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.reqOriginModule, other.reqOriginModule) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.testParserPayloadDetails == null ? 43 : this.testParserPayloadDetails.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.reqOriginModule == null ? 43 : this.reqOriginModule.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TestParserRequest, TestParserPayloadDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private TestParserPayloadDetails testParserPayloadDetails = null;
        private Scope scope = null;
        private String reqOriginModule = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder testParserPayloadDetails(TestParserPayloadDetails testParserPayloadDetails) {
            this.testParserPayloadDetails = testParserPayloadDetails;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder reqOriginModule(String reqOriginModule) {
            this.reqOriginModule = reqOriginModule;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestParserRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.testParserPayloadDetails(o.getTestParserPayloadDetails());
            this.scope(o.getScope());
            this.reqOriginModule(o.getReqOriginModule());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestParserRequest build() {
            TestParserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestParserPayloadDetails body) {
            this.testParserPayloadDetails(body);
            return this;
        }

        public TestParserRequest buildWithoutInvocationCallback() {
            TestParserRequest request = new TestParserRequest();
            request.namespaceName = this.namespaceName;
            request.testParserPayloadDetails = this.testParserPayloadDetails;
            request.scope = this.scope;
            request.reqOriginModule = this.reqOriginModule;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum Scope implements BmcEnum
    {
        LogLines("LOG_LINES"),
        LogEntries("LOG_ENTRIES"),
        LogLinesLogEntries("LOG_LINES_LOG_ENTRIES");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

