/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.LogAnalyticsResourceCategoryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveResourceCategoriesRequest
extends BmcRequest<LogAnalyticsResourceCategoryDetails> {
    private String namespaceName;
    private LogAnalyticsResourceCategoryDetails removeResourceCategoriesDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LogAnalyticsResourceCategoryDetails getRemoveResourceCategoriesDetails() {
        return this.removeResourceCategoriesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public LogAnalyticsResourceCategoryDetails getBody$() {
        return this.removeResourceCategoriesDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).removeResourceCategoriesDetails(this.removeResourceCategoriesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",removeResourceCategoriesDetails=").append(String.valueOf((Object)this.removeResourceCategoriesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveResourceCategoriesRequest)) {
            return false;
        }
        RemoveResourceCategoriesRequest other = (RemoveResourceCategoriesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.removeResourceCategoriesDetails, (Object)other.removeResourceCategoriesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.removeResourceCategoriesDetails == null ? 43 : this.removeResourceCategoriesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveResourceCategoriesRequest, LogAnalyticsResourceCategoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private LogAnalyticsResourceCategoryDetails removeResourceCategoriesDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder removeResourceCategoriesDetails(LogAnalyticsResourceCategoryDetails removeResourceCategoriesDetails) {
            this.removeResourceCategoriesDetails = removeResourceCategoriesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveResourceCategoriesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.removeResourceCategoriesDetails(o.getRemoveResourceCategoriesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveResourceCategoriesRequest build() {
            RemoveResourceCategoriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LogAnalyticsResourceCategoryDetails body) {
            this.removeResourceCategoriesDetails(body);
            return this;
        }

        public RemoveResourceCategoriesRequest buildWithoutInvocationCallback() {
            RemoveResourceCategoriesRequest request = new RemoveResourceCategoriesRequest();
            request.namespaceName = this.namespaceName;
            request.removeResourceCategoriesDetails = this.removeResourceCategoriesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

