/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListWarningsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private WarningState warningState;
    private String sourceName;
    private String sourcePattern;
    private String warningMessage;
    private String entityName;
    private String entityType;
    private String warningType;
    private Boolean isNoSource;
    private String startTime;
    private String endTime;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public WarningState getWarningState() {
        return this.warningState;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getWarningType() {
        return this.warningType;
    }

    public Boolean getIsNoSource() {
        return this.isNoSource;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).compartmentId(this.compartmentId).warningState(this.warningState).sourceName(this.sourceName).sourcePattern(this.sourcePattern).warningMessage(this.warningMessage).entityName(this.entityName).entityType(this.entityType).warningType(this.warningType).isNoSource(this.isNoSource).startTime(this.startTime).endTime(this.endTime).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",warningState=").append(String.valueOf((Object)this.warningState));
        sb.append(",sourceName=").append(String.valueOf(this.sourceName));
        sb.append(",sourcePattern=").append(String.valueOf(this.sourcePattern));
        sb.append(",warningMessage=").append(String.valueOf(this.warningMessage));
        sb.append(",entityName=").append(String.valueOf(this.entityName));
        sb.append(",entityType=").append(String.valueOf(this.entityType));
        sb.append(",warningType=").append(String.valueOf(this.warningType));
        sb.append(",isNoSource=").append(String.valueOf(this.isNoSource));
        sb.append(",startTime=").append(String.valueOf(this.startTime));
        sb.append(",endTime=").append(String.valueOf(this.endTime));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWarningsRequest)) {
            return false;
        }
        ListWarningsRequest other = (ListWarningsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.warningState, (Object)other.warningState) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.sourcePattern, other.sourcePattern) && Objects.equals(this.warningMessage, other.warningMessage) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.warningType, other.warningType) && Objects.equals(this.isNoSource, other.isNoSource) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.warningState == null ? 43 : this.warningState.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.sourcePattern == null ? 43 : this.sourcePattern.hashCode());
        result = result * 59 + (this.warningMessage == null ? 43 : this.warningMessage.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.warningType == null ? 43 : this.warningType.hashCode());
        result = result * 59 + (this.isNoSource == null ? 43 : this.isNoSource.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWarningsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String compartmentId = null;
        private WarningState warningState = null;
        private String sourceName = null;
        private String sourcePattern = null;
        private String warningMessage = null;
        private String entityName = null;
        private String entityType = null;
        private String warningType = null;
        private Boolean isNoSource = null;
        private String startTime = null;
        private String endTime = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder warningState(WarningState warningState) {
            this.warningState = warningState;
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder sourcePattern(String sourcePattern) {
            this.sourcePattern = sourcePattern;
            return this;
        }

        public Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder warningType(String warningType) {
            this.warningType = warningType;
            return this;
        }

        public Builder isNoSource(Boolean isNoSource) {
            this.isNoSource = isNoSource;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWarningsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.warningState(o.getWarningState());
            this.sourceName(o.getSourceName());
            this.sourcePattern(o.getSourcePattern());
            this.warningMessage(o.getWarningMessage());
            this.entityName(o.getEntityName());
            this.entityType(o.getEntityType());
            this.warningType(o.getWarningType());
            this.isNoSource(o.getIsNoSource());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWarningsRequest build() {
            ListWarningsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWarningsRequest buildWithoutInvocationCallback() {
            ListWarningsRequest request = new ListWarningsRequest();
            request.namespaceName = this.namespaceName;
            request.compartmentId = this.compartmentId;
            request.warningState = this.warningState;
            request.sourceName = this.sourceName;
            request.sourcePattern = this.sourcePattern;
            request.warningMessage = this.warningMessage;
            request.entityName = this.entityName;
            request.entityType = this.entityType;
            request.warningType = this.warningType;
            request.isNoSource = this.isNoSource;
            request.startTime = this.startTime;
            request.endTime = this.endTime;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        EntityType("EntityType"),
        SourceName("SourceName"),
        PatternText("PatternText"),
        FirstReported("FirstReported"),
        WarningMessage("WarningMessage"),
        Host("Host"),
        EntityName("EntityName"),
        InitialWarningDate("InitialWarningDate");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum WarningState implements BmcEnum
    {
        All("ALL"),
        Suppressed("SUPPRESSED"),
        Unsuppressed("UNSUPPRESSED");

        private final String value;
        private static Map<String, WarningState> map;

        private WarningState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WarningState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WarningState: " + key);
        }

        static {
            map = new HashMap<String, WarningState>();
            for (WarningState v : WarningState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

