/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class ImportCustomContentRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private InputStream importCustomContentFileBody;
    private Boolean isOverwrite;
    private String opcRetryToken;
    private String opcRequestId;
    private String expect;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public InputStream getImportCustomContentFileBody() {
        return this.importCustomContentFileBody;
    }

    public Boolean getIsOverwrite() {
        return this.isOverwrite;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpect() {
        return this.expect;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.importCustomContentFileBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).importCustomContentFileBody(this.importCustomContentFileBody).isOverwrite(this.isOverwrite).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).expect(this.expect);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",importCustomContentFileBody=").append(String.valueOf(this.importCustomContentFileBody));
        sb.append(",isOverwrite=").append(String.valueOf(this.isOverwrite));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportCustomContentRequest)) {
            return false;
        }
        ImportCustomContentRequest other = (ImportCustomContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.importCustomContentFileBody, other.importCustomContentFileBody) && Objects.equals(this.isOverwrite, other.isOverwrite) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.expect, other.expect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.importCustomContentFileBody == null ? 43 : this.importCustomContentFileBody.hashCode());
        result = result * 59 + (this.isOverwrite == null ? 43 : this.isOverwrite.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportCustomContentRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private InputStream importCustomContentFileBody = null;
        private Boolean isOverwrite = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String expect = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder importCustomContentFileBody(InputStream importCustomContentFileBody) {
            this.importCustomContentFileBody = importCustomContentFileBody;
            return this;
        }

        public Builder isOverwrite(Boolean isOverwrite) {
            this.isOverwrite = isOverwrite;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportCustomContentRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.importCustomContentFileBody(o.getImportCustomContentFileBody());
            this.isOverwrite(o.getIsOverwrite());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.expect(o.getExpect());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportCustomContentRequest build() {
            ImportCustomContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.importCustomContentFileBody(body);
            return this;
        }

        public ImportCustomContentRequest buildWithoutInvocationCallback() {
            ImportCustomContentRequest request = new ImportCustomContentRequest();
            request.namespaceName = this.namespaceName;
            request.importCustomContentFileBody = this.importCustomContentFileBody;
            request.isOverwrite = this.isOverwrite;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.expect = this.expect;
            return request;
        }
    }
}

