/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLogAnalyticsEntityTypeRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String entityTypeName;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).entityTypeName(this.entityTypeName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",entityTypeName=").append(String.valueOf(this.entityTypeName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLogAnalyticsEntityTypeRequest)) {
            return false;
        }
        GetLogAnalyticsEntityTypeRequest other = (GetLogAnalyticsEntityTypeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.entityTypeName, other.entityTypeName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.entityTypeName == null ? 43 : this.entityTypeName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogAnalyticsEntityTypeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String entityTypeName = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder entityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogAnalyticsEntityTypeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.entityTypeName(o.getEntityTypeName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogAnalyticsEntityTypeRequest build() {
            GetLogAnalyticsEntityTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLogAnalyticsEntityTypeRequest buildWithoutInvocationCallback() {
            GetLogAnalyticsEntityTypeRequest request = new GetLogAnalyticsEntityTypeRequest();
            request.namespaceName = this.namespaceName;
            request.entityTypeName = this.entityTypeName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

