/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.EstimateReleaseDataSizeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class EstimateReleaseDataSizeRequest
extends BmcRequest<EstimateReleaseDataSizeDetails> {
    private String namespaceName;
    private EstimateReleaseDataSizeDetails estimateReleaseDataSizeDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public EstimateReleaseDataSizeDetails getEstimateReleaseDataSizeDetails() {
        return this.estimateReleaseDataSizeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EstimateReleaseDataSizeDetails getBody$() {
        return this.estimateReleaseDataSizeDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).estimateReleaseDataSizeDetails(this.estimateReleaseDataSizeDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",estimateReleaseDataSizeDetails=").append(String.valueOf((Object)this.estimateReleaseDataSizeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EstimateReleaseDataSizeRequest)) {
            return false;
        }
        EstimateReleaseDataSizeRequest other = (EstimateReleaseDataSizeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.estimateReleaseDataSizeDetails, (Object)other.estimateReleaseDataSizeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.estimateReleaseDataSizeDetails == null ? 43 : this.estimateReleaseDataSizeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<EstimateReleaseDataSizeRequest, EstimateReleaseDataSizeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private EstimateReleaseDataSizeDetails estimateReleaseDataSizeDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder estimateReleaseDataSizeDetails(EstimateReleaseDataSizeDetails estimateReleaseDataSizeDetails) {
            this.estimateReleaseDataSizeDetails = estimateReleaseDataSizeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EstimateReleaseDataSizeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.estimateReleaseDataSizeDetails(o.getEstimateReleaseDataSizeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EstimateReleaseDataSizeRequest build() {
            EstimateReleaseDataSizeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EstimateReleaseDataSizeDetails body) {
            this.estimateReleaseDataSizeDetails(body);
            return this;
        }

        public EstimateReleaseDataSizeRequest buildWithoutInvocationCallback() {
            EstimateReleaseDataSizeRequest request = new EstimateReleaseDataSizeRequest();
            request.namespaceName = this.namespaceName;
            request.estimateReleaseDataSizeDetails = this.estimateReleaseDataSizeDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

