/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.CreateScheduledTaskDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateScheduledTaskRequest
extends BmcRequest<CreateScheduledTaskDetails> {
    private String namespaceName;
    private CreateScheduledTaskDetails createScheduledTaskDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CreateScheduledTaskDetails getCreateScheduledTaskDetails() {
        return this.createScheduledTaskDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateScheduledTaskDetails getBody$() {
        return this.createScheduledTaskDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).createScheduledTaskDetails(this.createScheduledTaskDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",createScheduledTaskDetails=").append(String.valueOf((Object)this.createScheduledTaskDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateScheduledTaskRequest)) {
            return false;
        }
        CreateScheduledTaskRequest other = (CreateScheduledTaskRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.createScheduledTaskDetails, (Object)other.createScheduledTaskDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.createScheduledTaskDetails == null ? 43 : this.createScheduledTaskDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateScheduledTaskRequest, CreateScheduledTaskDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private CreateScheduledTaskDetails createScheduledTaskDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder createScheduledTaskDetails(CreateScheduledTaskDetails createScheduledTaskDetails) {
            this.createScheduledTaskDetails = createScheduledTaskDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateScheduledTaskRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.createScheduledTaskDetails(o.getCreateScheduledTaskDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateScheduledTaskRequest build() {
            CreateScheduledTaskRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateScheduledTaskDetails body) {
            this.createScheduledTaskDetails(body);
            return this;
        }

        public CreateScheduledTaskRequest buildWithoutInvocationCallback() {
            CreateScheduledTaskRequest request = new CreateScheduledTaskRequest();
            request.namespaceName = this.namespaceName;
            request.createScheduledTaskDetails = this.createScheduledTaskDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

