/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StorageUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activeDataSizeInBytes")
    private final Long activeDataSizeInBytes;
    @JsonProperty(value="archivedDataSizeInBytes")
    private final Long archivedDataSizeInBytes;
    @JsonProperty(value="recalledArchivedDataSizeInBytes")
    private final Long recalledArchivedDataSizeInBytes;

    @Deprecated
    @ConstructorProperties(value={"activeDataSizeInBytes", "archivedDataSizeInBytes", "recalledArchivedDataSizeInBytes"})
    public StorageUsage(Long activeDataSizeInBytes, Long archivedDataSizeInBytes, Long recalledArchivedDataSizeInBytes) {
        this.activeDataSizeInBytes = activeDataSizeInBytes;
        this.archivedDataSizeInBytes = archivedDataSizeInBytes;
        this.recalledArchivedDataSizeInBytes = recalledArchivedDataSizeInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getActiveDataSizeInBytes() {
        return this.activeDataSizeInBytes;
    }

    public Long getArchivedDataSizeInBytes() {
        return this.archivedDataSizeInBytes;
    }

    public Long getRecalledArchivedDataSizeInBytes() {
        return this.recalledArchivedDataSizeInBytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageUsage(");
        sb.append("super=").append(super.toString());
        sb.append("activeDataSizeInBytes=").append(String.valueOf(this.activeDataSizeInBytes));
        sb.append(", archivedDataSizeInBytes=").append(String.valueOf(this.archivedDataSizeInBytes));
        sb.append(", recalledArchivedDataSizeInBytes=").append(String.valueOf(this.recalledArchivedDataSizeInBytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageUsage)) {
            return false;
        }
        StorageUsage other = (StorageUsage)((Object)o);
        return Objects.equals(this.activeDataSizeInBytes, other.activeDataSizeInBytes) && Objects.equals(this.archivedDataSizeInBytes, other.archivedDataSizeInBytes) && Objects.equals(this.recalledArchivedDataSizeInBytes, other.recalledArchivedDataSizeInBytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activeDataSizeInBytes == null ? 43 : this.activeDataSizeInBytes.hashCode());
        result = result * 59 + (this.archivedDataSizeInBytes == null ? 43 : this.archivedDataSizeInBytes.hashCode());
        result = result * 59 + (this.recalledArchivedDataSizeInBytes == null ? 43 : this.recalledArchivedDataSizeInBytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activeDataSizeInBytes")
        private Long activeDataSizeInBytes;
        @JsonProperty(value="archivedDataSizeInBytes")
        private Long archivedDataSizeInBytes;
        @JsonProperty(value="recalledArchivedDataSizeInBytes")
        private Long recalledArchivedDataSizeInBytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activeDataSizeInBytes(Long activeDataSizeInBytes) {
            this.activeDataSizeInBytes = activeDataSizeInBytes;
            this.__explicitlySet__.add("activeDataSizeInBytes");
            return this;
        }

        public Builder archivedDataSizeInBytes(Long archivedDataSizeInBytes) {
            this.archivedDataSizeInBytes = archivedDataSizeInBytes;
            this.__explicitlySet__.add("archivedDataSizeInBytes");
            return this;
        }

        public Builder recalledArchivedDataSizeInBytes(Long recalledArchivedDataSizeInBytes) {
            this.recalledArchivedDataSizeInBytes = recalledArchivedDataSizeInBytes;
            this.__explicitlySet__.add("recalledArchivedDataSizeInBytes");
            return this;
        }

        public StorageUsage build() {
            StorageUsage model = new StorageUsage(this.activeDataSizeInBytes, this.archivedDataSizeInBytes, this.recalledArchivedDataSizeInBytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StorageUsage model) {
            if (model.wasPropertyExplicitlySet("activeDataSizeInBytes")) {
                this.activeDataSizeInBytes(model.getActiveDataSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("archivedDataSizeInBytes")) {
                this.archivedDataSizeInBytes(model.getArchivedDataSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("recalledArchivedDataSizeInBytes")) {
                this.recalledArchivedDataSizeInBytes(model.getRecalledArchivedDataSizeInBytes());
            }
            return this;
        }
    }
}

