/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.Action;
import com.oracle.bmc.loganalytics.model.Schedule;
import com.oracle.bmc.loganalytics.model.ScheduledTask;
import com.oracle.bmc.loganalytics.model.TaskType;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class StandardTask
extends ScheduledTask {
    @JsonProperty(value="lastExecutionStatus")
    private final LastExecutionStatus lastExecutionStatus;
    @JsonProperty(value="timeLastExecuted")
    private final Date timeLastExecuted;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StandardTask(String id, String displayName, TaskType taskType, List<Schedule> schedules, Action action, ScheduledTask.TaskStatus taskStatus, ScheduledTask.PauseReason pauseReason, String workRequestId, Long numOccurrences, String compartmentId, Date timeCreated, Date timeUpdated, Date timeOfNextExecution, ScheduledTask.LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, LastExecutionStatus lastExecutionStatus, Date timeLastExecuted) {
        super(id, displayName, taskType, schedules, action, taskStatus, pauseReason, workRequestId, numOccurrences, compartmentId, timeCreated, timeUpdated, timeOfNextExecution, lifecycleState, freeformTags, definedTags);
        this.lastExecutionStatus = lastExecutionStatus;
        this.timeLastExecuted = timeLastExecuted;
    }

    public LastExecutionStatus getLastExecutionStatus() {
        return this.lastExecutionStatus;
    }

    public Date getTimeLastExecuted() {
        return this.timeLastExecuted;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StandardTask(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", lastExecutionStatus=").append(String.valueOf((Object)this.lastExecutionStatus));
        sb.append(", timeLastExecuted=").append(String.valueOf(this.timeLastExecuted));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardTask)) {
            return false;
        }
        StandardTask other = (StandardTask)((Object)o);
        return Objects.equals((Object)this.lastExecutionStatus, (Object)other.lastExecutionStatus) && Objects.equals(this.timeLastExecuted, other.timeLastExecuted) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.lastExecutionStatus == null ? 43 : this.lastExecutionStatus.hashCode());
        result = result * 59 + (this.timeLastExecuted == null ? 43 : this.timeLastExecuted.hashCode());
        return result;
    }

    public static enum LastExecutionStatus implements BmcEnum
    {
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LastExecutionStatus> map;

        private LastExecutionStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LastExecutionStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LastExecutionStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LastExecutionStatus.class);
            map = new HashMap<String, LastExecutionStatus>();
            for (LastExecutionStatus v : LastExecutionStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="schedules")
        private List<Schedule> schedules;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="taskStatus")
        private ScheduledTask.TaskStatus taskStatus;
        @JsonProperty(value="pauseReason")
        private ScheduledTask.PauseReason pauseReason;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonProperty(value="numOccurrences")
        private Long numOccurrences;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeOfNextExecution")
        private Date timeOfNextExecution;
        @JsonProperty(value="lifecycleState")
        private ScheduledTask.LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="lastExecutionStatus")
        private LastExecutionStatus lastExecutionStatus;
        @JsonProperty(value="timeLastExecuted")
        private Date timeLastExecuted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder schedules(List<Schedule> schedules) {
            this.schedules = schedules;
            this.__explicitlySet__.add("schedules");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder taskStatus(ScheduledTask.TaskStatus taskStatus) {
            this.taskStatus = taskStatus;
            this.__explicitlySet__.add("taskStatus");
            return this;
        }

        public Builder pauseReason(ScheduledTask.PauseReason pauseReason) {
            this.pauseReason = pauseReason;
            this.__explicitlySet__.add("pauseReason");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public Builder numOccurrences(Long numOccurrences) {
            this.numOccurrences = numOccurrences;
            this.__explicitlySet__.add("numOccurrences");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeOfNextExecution(Date timeOfNextExecution) {
            this.timeOfNextExecution = timeOfNextExecution;
            this.__explicitlySet__.add("timeOfNextExecution");
            return this;
        }

        public Builder lifecycleState(ScheduledTask.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder lastExecutionStatus(LastExecutionStatus lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
            this.__explicitlySet__.add("lastExecutionStatus");
            return this;
        }

        public Builder timeLastExecuted(Date timeLastExecuted) {
            this.timeLastExecuted = timeLastExecuted;
            this.__explicitlySet__.add("timeLastExecuted");
            return this;
        }

        public StandardTask build() {
            StandardTask model = new StandardTask(this.id, this.displayName, this.taskType, this.schedules, this.action, this.taskStatus, this.pauseReason, this.workRequestId, this.numOccurrences, this.compartmentId, this.timeCreated, this.timeUpdated, this.timeOfNextExecution, this.lifecycleState, this.freeformTags, this.definedTags, this.lastExecutionStatus, this.timeLastExecuted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StandardTask model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("schedules")) {
                this.schedules(model.getSchedules());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("taskStatus")) {
                this.taskStatus(model.getTaskStatus());
            }
            if (model.wasPropertyExplicitlySet("pauseReason")) {
                this.pauseReason(model.getPauseReason());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("numOccurrences")) {
                this.numOccurrences(model.getNumOccurrences());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeOfNextExecution")) {
                this.timeOfNextExecution(model.getTimeOfNextExecution());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("lastExecutionStatus")) {
                this.lastExecutionStatus(model.getLastExecutionStatus());
            }
            if (model.wasPropertyExplicitlySet("timeLastExecuted")) {
                this.timeLastExecuted(model.getTimeLastExecuted());
            }
            return this;
        }
    }
}

