/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.CronSchedule;
import com.oracle.bmc.loganalytics.model.FixedFrequencySchedule;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Schedule.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CronSchedule.class, name="CRON"), @JsonSubTypes.Type(value=FixedFrequencySchedule.class, name="FIXED_FREQUENCY")})
@JsonFilter(value="explicitlySetFilter")
public class Schedule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="misfirePolicy")
    private final MisfirePolicy misfirePolicy;
    @JsonProperty(value="timeOfFirstExecution")
    private final Date timeOfFirstExecution;

    @Deprecated
    @ConstructorProperties(value={"misfirePolicy", "timeOfFirstExecution"})
    protected Schedule(MisfirePolicy misfirePolicy, Date timeOfFirstExecution) {
        this.misfirePolicy = misfirePolicy;
        this.timeOfFirstExecution = timeOfFirstExecution;
    }

    public MisfirePolicy getMisfirePolicy() {
        return this.misfirePolicy;
    }

    public Date getTimeOfFirstExecution() {
        return this.timeOfFirstExecution;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Schedule(");
        sb.append("super=").append(super.toString());
        sb.append("misfirePolicy=").append(String.valueOf((Object)this.misfirePolicy));
        sb.append(", timeOfFirstExecution=").append(String.valueOf(this.timeOfFirstExecution));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)((Object)o);
        return Objects.equals((Object)this.misfirePolicy, (Object)other.misfirePolicy) && Objects.equals(this.timeOfFirstExecution, other.timeOfFirstExecution) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.misfirePolicy == null ? 43 : this.misfirePolicy.hashCode());
        result = result * 59 + (this.timeOfFirstExecution == null ? 43 : this.timeOfFirstExecution.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        FixedFrequency("FIXED_FREQUENCY"),
        Cron("CRON"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MisfirePolicy implements BmcEnum
    {
        RetryOnce("RETRY_ONCE"),
        RetryIndefinitely("RETRY_INDEFINITELY"),
        Skip("SKIP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MisfirePolicy> map;

        private MisfirePolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MisfirePolicy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MisfirePolicy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MisfirePolicy.class);
            map = new HashMap<String, MisfirePolicy>();
            for (MisfirePolicy v : MisfirePolicy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

