/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RecalledData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeDataEnded")
    private final Date timeDataEnded;
    @JsonProperty(value="timeDataStarted")
    private final Date timeDataStarted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="recallCount")
    private final Integer recallCount;
    @JsonProperty(value="storageUsageInBytes")
    private final Long storageUsageInBytes;

    @Deprecated
    @ConstructorProperties(value={"timeDataEnded", "timeDataStarted", "timeStarted", "status", "recallCount", "storageUsageInBytes"})
    public RecalledData(Date timeDataEnded, Date timeDataStarted, Date timeStarted, Status status, Integer recallCount, Long storageUsageInBytes) {
        this.timeDataEnded = timeDataEnded;
        this.timeDataStarted = timeDataStarted;
        this.timeStarted = timeStarted;
        this.status = status;
        this.recallCount = recallCount;
        this.storageUsageInBytes = storageUsageInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getRecallCount() {
        return this.recallCount;
    }

    public Long getStorageUsageInBytes() {
        return this.storageUsageInBytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RecalledData(");
        sb.append("super=").append(super.toString());
        sb.append("timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(", timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", recallCount=").append(String.valueOf(this.recallCount));
        sb.append(", storageUsageInBytes=").append(String.valueOf(this.storageUsageInBytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecalledData)) {
            return false;
        }
        RecalledData other = (RecalledData)((Object)o);
        return Objects.equals(this.timeDataEnded, other.timeDataEnded) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.recallCount, other.recallCount) && Objects.equals(this.storageUsageInBytes, other.storageUsageInBytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.recallCount == null ? 43 : this.recallCount.hashCode());
        result = result * 59 + (this.storageUsageInBytes == null ? 43 : this.storageUsageInBytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Recalled("RECALLED"),
        Pending("PENDING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeDataEnded")
        private Date timeDataEnded;
        @JsonProperty(value="timeDataStarted")
        private Date timeDataStarted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="recallCount")
        private Integer recallCount;
        @JsonProperty(value="storageUsageInBytes")
        private Long storageUsageInBytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            this.__explicitlySet__.add("timeDataEnded");
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            this.__explicitlySet__.add("timeDataStarted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder recallCount(Integer recallCount) {
            this.recallCount = recallCount;
            this.__explicitlySet__.add("recallCount");
            return this;
        }

        public Builder storageUsageInBytes(Long storageUsageInBytes) {
            this.storageUsageInBytes = storageUsageInBytes;
            this.__explicitlySet__.add("storageUsageInBytes");
            return this;
        }

        public RecalledData build() {
            RecalledData model = new RecalledData(this.timeDataEnded, this.timeDataStarted, this.timeStarted, this.status, this.recallCount, this.storageUsageInBytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RecalledData model) {
            if (model.wasPropertyExplicitlySet("timeDataEnded")) {
                this.timeDataEnded(model.getTimeDataEnded());
            }
            if (model.wasPropertyExplicitlySet("timeDataStarted")) {
                this.timeDataStarted(model.getTimeDataStarted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("recallCount")) {
                this.recallCount(model.getRecallCount());
            }
            if (model.wasPropertyExplicitlySet("storageUsageInBytes")) {
                this.storageUsageInBytes(model.getStorageUsageInBytes());
            }
            return this;
        }
    }
}

