/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum PayloadType implements BmcEnum
{
    Json("JSON"),
    Gzip("GZIP"),
    Zip("ZIP");

    private final String value;
    private static Map<String, PayloadType> map;

    private PayloadType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static PayloadType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid PayloadType: " + key);
    }

    static {
        map = new HashMap<String, PayloadType>();
        for (PayloadType v : PayloadType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

