/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LookupSummaryReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userCreatedCount")
    private final Integer userCreatedCount;
    @JsonProperty(value="oracleDefinedCount")
    private final Integer oracleDefinedCount;
    @JsonProperty(value="totalCount")
    private final Integer totalCount;

    @Deprecated
    @ConstructorProperties(value={"userCreatedCount", "oracleDefinedCount", "totalCount"})
    public LookupSummaryReport(Integer userCreatedCount, Integer oracleDefinedCount, Integer totalCount) {
        this.userCreatedCount = userCreatedCount;
        this.oracleDefinedCount = oracleDefinedCount;
        this.totalCount = totalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getUserCreatedCount() {
        return this.userCreatedCount;
    }

    public Integer getOracleDefinedCount() {
        return this.oracleDefinedCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LookupSummaryReport(");
        sb.append("super=").append(super.toString());
        sb.append("userCreatedCount=").append(String.valueOf(this.userCreatedCount));
        sb.append(", oracleDefinedCount=").append(String.valueOf(this.oracleDefinedCount));
        sb.append(", totalCount=").append(String.valueOf(this.totalCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupSummaryReport)) {
            return false;
        }
        LookupSummaryReport other = (LookupSummaryReport)((Object)o);
        return Objects.equals(this.userCreatedCount, other.userCreatedCount) && Objects.equals(this.oracleDefinedCount, other.oracleDefinedCount) && Objects.equals(this.totalCount, other.totalCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userCreatedCount == null ? 43 : this.userCreatedCount.hashCode());
        result = result * 59 + (this.oracleDefinedCount == null ? 43 : this.oracleDefinedCount.hashCode());
        result = result * 59 + (this.totalCount == null ? 43 : this.totalCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userCreatedCount")
        private Integer userCreatedCount;
        @JsonProperty(value="oracleDefinedCount")
        private Integer oracleDefinedCount;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userCreatedCount(Integer userCreatedCount) {
            this.userCreatedCount = userCreatedCount;
            this.__explicitlySet__.add("userCreatedCount");
            return this;
        }

        public Builder oracleDefinedCount(Integer oracleDefinedCount) {
            this.oracleDefinedCount = oracleDefinedCount;
            this.__explicitlySet__.add("oracleDefinedCount");
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            this.__explicitlySet__.add("totalCount");
            return this;
        }

        public LookupSummaryReport build() {
            LookupSummaryReport model = new LookupSummaryReport(this.userCreatedCount, this.oracleDefinedCount, this.totalCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LookupSummaryReport model) {
            if (model.wasPropertyExplicitlySet("userCreatedCount")) {
                this.userCreatedCount(model.getUserCreatedCount());
            }
            if (model.wasPropertyExplicitlySet("oracleDefinedCount")) {
                this.oracleDefinedCount(model.getOracleDefinedCount());
            }
            if (model.wasPropertyExplicitlySet("totalCount")) {
                this.totalCount(model.getTotalCount());
            }
            return this;
        }
    }
}

