/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsSourceEntityType
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceId")
    private final Long sourceId;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="entityTypeCategory")
    private final String entityTypeCategory;
    @JsonProperty(value="entityTypeDisplayName")
    private final String entityTypeDisplayName;

    @Deprecated
    @ConstructorProperties(value={"sourceId", "entityType", "entityTypeCategory", "entityTypeDisplayName"})
    public LogAnalyticsSourceEntityType(Long sourceId, String entityType, String entityTypeCategory, String entityTypeDisplayName) {
        this.sourceId = sourceId;
        this.entityType = entityType;
        this.entityTypeCategory = entityTypeCategory;
        this.entityTypeDisplayName = entityTypeDisplayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityTypeCategory() {
        return this.entityTypeCategory;
    }

    public String getEntityTypeDisplayName() {
        return this.entityTypeDisplayName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsSourceEntityType(");
        sb.append("super=").append(super.toString());
        sb.append("sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", entityTypeCategory=").append(String.valueOf(this.entityTypeCategory));
        sb.append(", entityTypeDisplayName=").append(String.valueOf(this.entityTypeDisplayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsSourceEntityType)) {
            return false;
        }
        LogAnalyticsSourceEntityType other = (LogAnalyticsSourceEntityType)((Object)o);
        return Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.entityTypeCategory, other.entityTypeCategory) && Objects.equals(this.entityTypeDisplayName, other.entityTypeDisplayName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.entityTypeCategory == null ? 43 : this.entityTypeCategory.hashCode());
        result = result * 59 + (this.entityTypeDisplayName == null ? 43 : this.entityTypeDisplayName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="entityTypeCategory")
        private String entityTypeCategory;
        @JsonProperty(value="entityTypeDisplayName")
        private String entityTypeDisplayName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder entityTypeCategory(String entityTypeCategory) {
            this.entityTypeCategory = entityTypeCategory;
            this.__explicitlySet__.add("entityTypeCategory");
            return this;
        }

        public Builder entityTypeDisplayName(String entityTypeDisplayName) {
            this.entityTypeDisplayName = entityTypeDisplayName;
            this.__explicitlySet__.add("entityTypeDisplayName");
            return this;
        }

        public LogAnalyticsSourceEntityType build() {
            LogAnalyticsSourceEntityType model = new LogAnalyticsSourceEntityType(this.sourceId, this.entityType, this.entityTypeCategory, this.entityTypeDisplayName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsSourceEntityType model) {
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("entityTypeCategory")) {
                this.entityTypeCategory(model.getEntityTypeCategory());
            }
            if (model.wasPropertyExplicitlySet("entityTypeDisplayName")) {
                this.entityTypeDisplayName(model.getEntityTypeDisplayName());
            }
            return this;
        }
    }
}

