/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsSourceDataFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="hashType")
    private final Integer hashType;
    @JsonProperty(value="dataFilterId")
    private final Long dataFilterId;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="matchRegularExpression")
    private final String matchRegularExpression;
    @JsonProperty(value="order")
    private final Long order;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="replacementString")
    private final String replacementString;
    @JsonProperty(value="sourceId")
    private final Long sourceId;
    @JsonProperty(value="filterType")
    private final FilterType filterType;

    @Deprecated
    @ConstructorProperties(value={"description", "displayName", "editVersion", "isEnabled", "fieldName", "hashType", "dataFilterId", "isSystem", "matchRegularExpression", "order", "path", "replacementString", "sourceId", "filterType"})
    public LogAnalyticsSourceDataFilter(String description, String displayName, Long editVersion, Boolean isEnabled, String fieldName, Integer hashType, Long dataFilterId, Boolean isSystem, String matchRegularExpression, Long order, String path, String replacementString, Long sourceId, FilterType filterType) {
        this.description = description;
        this.displayName = displayName;
        this.editVersion = editVersion;
        this.isEnabled = isEnabled;
        this.fieldName = fieldName;
        this.hashType = hashType;
        this.dataFilterId = dataFilterId;
        this.isSystem = isSystem;
        this.matchRegularExpression = matchRegularExpression;
        this.order = order;
        this.path = path;
        this.replacementString = replacementString;
        this.sourceId = sourceId;
        this.filterType = filterType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getHashType() {
        return this.hashType;
    }

    public Long getDataFilterId() {
        return this.dataFilterId;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getMatchRegularExpression() {
        return this.matchRegularExpression;
    }

    public Long getOrder() {
        return this.order;
    }

    public String getPath() {
        return this.path;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsSourceDataFilter(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", hashType=").append(String.valueOf(this.hashType));
        sb.append(", dataFilterId=").append(String.valueOf(this.dataFilterId));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", matchRegularExpression=").append(String.valueOf(this.matchRegularExpression));
        sb.append(", order=").append(String.valueOf(this.order));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", replacementString=").append(String.valueOf(this.replacementString));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", filterType=").append(String.valueOf((Object)this.filterType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsSourceDataFilter)) {
            return false;
        }
        LogAnalyticsSourceDataFilter other = (LogAnalyticsSourceDataFilter)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.hashType, other.hashType) && Objects.equals(this.dataFilterId, other.dataFilterId) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.matchRegularExpression, other.matchRegularExpression) && Objects.equals(this.order, other.order) && Objects.equals(this.path, other.path) && Objects.equals(this.replacementString, other.replacementString) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals((Object)this.filterType, (Object)other.filterType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.hashType == null ? 43 : this.hashType.hashCode());
        result = result * 59 + (this.dataFilterId == null ? 43 : this.dataFilterId.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.matchRegularExpression == null ? 43 : this.matchRegularExpression.hashCode());
        result = result * 59 + (this.order == null ? 43 : this.order.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.replacementString == null ? 43 : this.replacementString.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.filterType == null ? 43 : this.filterType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FilterType implements BmcEnum
    {
        Mask("MASK"),
        HashMask("HASH_MASK"),
        DropLogEntry("DROP_LOG_ENTRY"),
        DropString("DROP_STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FilterType> map;

        private FilterType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FilterType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FilterType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FilterType.class);
            map = new HashMap<String, FilterType>();
            for (FilterType v : FilterType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="hashType")
        private Integer hashType;
        @JsonProperty(value="dataFilterId")
        private Long dataFilterId;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="matchRegularExpression")
        private String matchRegularExpression;
        @JsonProperty(value="order")
        private Long order;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="replacementString")
        private String replacementString;
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonProperty(value="filterType")
        private FilterType filterType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder hashType(Integer hashType) {
            this.hashType = hashType;
            this.__explicitlySet__.add("hashType");
            return this;
        }

        public Builder dataFilterId(Long dataFilterId) {
            this.dataFilterId = dataFilterId;
            this.__explicitlySet__.add("dataFilterId");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder matchRegularExpression(String matchRegularExpression) {
            this.matchRegularExpression = matchRegularExpression;
            this.__explicitlySet__.add("matchRegularExpression");
            return this;
        }

        public Builder order(Long order) {
            this.order = order;
            this.__explicitlySet__.add("order");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder replacementString(String replacementString) {
            this.replacementString = replacementString;
            this.__explicitlySet__.add("replacementString");
            return this;
        }

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder filterType(FilterType filterType) {
            this.filterType = filterType;
            this.__explicitlySet__.add("filterType");
            return this;
        }

        public LogAnalyticsSourceDataFilter build() {
            LogAnalyticsSourceDataFilter model = new LogAnalyticsSourceDataFilter(this.description, this.displayName, this.editVersion, this.isEnabled, this.fieldName, this.hashType, this.dataFilterId, this.isSystem, this.matchRegularExpression, this.order, this.path, this.replacementString, this.sourceId, this.filterType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsSourceDataFilter model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("hashType")) {
                this.hashType(model.getHashType());
            }
            if (model.wasPropertyExplicitlySet("dataFilterId")) {
                this.dataFilterId(model.getDataFilterId());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("matchRegularExpression")) {
                this.matchRegularExpression(model.getMatchRegularExpression());
            }
            if (model.wasPropertyExplicitlySet("order")) {
                this.order(model.getOrder());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("replacementString")) {
                this.replacementString(model.getReplacementString());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("filterType")) {
                this.filterType(model.getFilterType());
            }
            return this;
        }
    }
}

