/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.LogAnalyticsField;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParser;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsParserField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="field")
    private final LogAnalyticsField field;
    @JsonProperty(value="parserFieldId")
    private final Long parserFieldId;
    @JsonProperty(value="parserFieldExpression")
    private final String parserFieldExpression;
    @JsonProperty(value="parserFieldName")
    private final String parserFieldName;
    @JsonProperty(value="storageFieldName")
    private final String storageFieldName;
    @JsonProperty(value="parserFieldIntegratorName")
    private final String parserFieldIntegratorName;
    @JsonProperty(value="parserName")
    private final String parserName;
    @JsonProperty(value="parserFieldSequence")
    private final Long parserFieldSequence;
    @JsonProperty(value="parser")
    private final LogAnalyticsParser parser;
    @JsonProperty(value="structuredColumnInfo")
    private final String structuredColumnInfo;

    @Deprecated
    @ConstructorProperties(value={"field", "parserFieldId", "parserFieldExpression", "parserFieldName", "storageFieldName", "parserFieldIntegratorName", "parserName", "parserFieldSequence", "parser", "structuredColumnInfo"})
    public LogAnalyticsParserField(LogAnalyticsField field, Long parserFieldId, String parserFieldExpression, String parserFieldName, String storageFieldName, String parserFieldIntegratorName, String parserName, Long parserFieldSequence, LogAnalyticsParser parser, String structuredColumnInfo) {
        this.field = field;
        this.parserFieldId = parserFieldId;
        this.parserFieldExpression = parserFieldExpression;
        this.parserFieldName = parserFieldName;
        this.storageFieldName = storageFieldName;
        this.parserFieldIntegratorName = parserFieldIntegratorName;
        this.parserName = parserName;
        this.parserFieldSequence = parserFieldSequence;
        this.parser = parser;
        this.structuredColumnInfo = structuredColumnInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LogAnalyticsField getField() {
        return this.field;
    }

    public Long getParserFieldId() {
        return this.parserFieldId;
    }

    public String getParserFieldExpression() {
        return this.parserFieldExpression;
    }

    public String getParserFieldName() {
        return this.parserFieldName;
    }

    public String getStorageFieldName() {
        return this.storageFieldName;
    }

    public String getParserFieldIntegratorName() {
        return this.parserFieldIntegratorName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public Long getParserFieldSequence() {
        return this.parserFieldSequence;
    }

    public LogAnalyticsParser getParser() {
        return this.parser;
    }

    public String getStructuredColumnInfo() {
        return this.structuredColumnInfo;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsParserField(");
        sb.append("super=").append(super.toString());
        sb.append("field=").append(String.valueOf((Object)this.field));
        sb.append(", parserFieldId=").append(String.valueOf(this.parserFieldId));
        sb.append(", parserFieldExpression=").append(String.valueOf(this.parserFieldExpression));
        sb.append(", parserFieldName=").append(String.valueOf(this.parserFieldName));
        sb.append(", storageFieldName=").append(String.valueOf(this.storageFieldName));
        sb.append(", parserFieldIntegratorName=").append(String.valueOf(this.parserFieldIntegratorName));
        sb.append(", parserName=").append(String.valueOf(this.parserName));
        sb.append(", parserFieldSequence=").append(String.valueOf(this.parserFieldSequence));
        sb.append(", parser=").append(String.valueOf((Object)this.parser));
        sb.append(", structuredColumnInfo=").append(String.valueOf(this.structuredColumnInfo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsParserField)) {
            return false;
        }
        LogAnalyticsParserField other = (LogAnalyticsParserField)((Object)o);
        return Objects.equals((Object)this.field, (Object)other.field) && Objects.equals(this.parserFieldId, other.parserFieldId) && Objects.equals(this.parserFieldExpression, other.parserFieldExpression) && Objects.equals(this.parserFieldName, other.parserFieldName) && Objects.equals(this.storageFieldName, other.storageFieldName) && Objects.equals(this.parserFieldIntegratorName, other.parserFieldIntegratorName) && Objects.equals(this.parserName, other.parserName) && Objects.equals(this.parserFieldSequence, other.parserFieldSequence) && Objects.equals((Object)this.parser, (Object)other.parser) && Objects.equals(this.structuredColumnInfo, other.structuredColumnInfo) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.field == null ? 43 : this.field.hashCode());
        result = result * 59 + (this.parserFieldId == null ? 43 : this.parserFieldId.hashCode());
        result = result * 59 + (this.parserFieldExpression == null ? 43 : this.parserFieldExpression.hashCode());
        result = result * 59 + (this.parserFieldName == null ? 43 : this.parserFieldName.hashCode());
        result = result * 59 + (this.storageFieldName == null ? 43 : this.storageFieldName.hashCode());
        result = result * 59 + (this.parserFieldIntegratorName == null ? 43 : this.parserFieldIntegratorName.hashCode());
        result = result * 59 + (this.parserName == null ? 43 : this.parserName.hashCode());
        result = result * 59 + (this.parserFieldSequence == null ? 43 : this.parserFieldSequence.hashCode());
        result = result * 59 + (this.parser == null ? 43 : this.parser.hashCode());
        result = result * 59 + (this.structuredColumnInfo == null ? 43 : this.structuredColumnInfo.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="field")
        private LogAnalyticsField field;
        @JsonProperty(value="parserFieldId")
        private Long parserFieldId;
        @JsonProperty(value="parserFieldExpression")
        private String parserFieldExpression;
        @JsonProperty(value="parserFieldName")
        private String parserFieldName;
        @JsonProperty(value="storageFieldName")
        private String storageFieldName;
        @JsonProperty(value="parserFieldIntegratorName")
        private String parserFieldIntegratorName;
        @JsonProperty(value="parserName")
        private String parserName;
        @JsonProperty(value="parserFieldSequence")
        private Long parserFieldSequence;
        @JsonProperty(value="parser")
        private LogAnalyticsParser parser;
        @JsonProperty(value="structuredColumnInfo")
        private String structuredColumnInfo;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder field(LogAnalyticsField field) {
            this.field = field;
            this.__explicitlySet__.add("field");
            return this;
        }

        public Builder parserFieldId(Long parserFieldId) {
            this.parserFieldId = parserFieldId;
            this.__explicitlySet__.add("parserFieldId");
            return this;
        }

        public Builder parserFieldExpression(String parserFieldExpression) {
            this.parserFieldExpression = parserFieldExpression;
            this.__explicitlySet__.add("parserFieldExpression");
            return this;
        }

        public Builder parserFieldName(String parserFieldName) {
            this.parserFieldName = parserFieldName;
            this.__explicitlySet__.add("parserFieldName");
            return this;
        }

        public Builder storageFieldName(String storageFieldName) {
            this.storageFieldName = storageFieldName;
            this.__explicitlySet__.add("storageFieldName");
            return this;
        }

        public Builder parserFieldIntegratorName(String parserFieldIntegratorName) {
            this.parserFieldIntegratorName = parserFieldIntegratorName;
            this.__explicitlySet__.add("parserFieldIntegratorName");
            return this;
        }

        public Builder parserName(String parserName) {
            this.parserName = parserName;
            this.__explicitlySet__.add("parserName");
            return this;
        }

        public Builder parserFieldSequence(Long parserFieldSequence) {
            this.parserFieldSequence = parserFieldSequence;
            this.__explicitlySet__.add("parserFieldSequence");
            return this;
        }

        public Builder parser(LogAnalyticsParser parser) {
            this.parser = parser;
            this.__explicitlySet__.add("parser");
            return this;
        }

        public Builder structuredColumnInfo(String structuredColumnInfo) {
            this.structuredColumnInfo = structuredColumnInfo;
            this.__explicitlySet__.add("structuredColumnInfo");
            return this;
        }

        public LogAnalyticsParserField build() {
            LogAnalyticsParserField model = new LogAnalyticsParserField(this.field, this.parserFieldId, this.parserFieldExpression, this.parserFieldName, this.storageFieldName, this.parserFieldIntegratorName, this.parserName, this.parserFieldSequence, this.parser, this.structuredColumnInfo);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsParserField model) {
            if (model.wasPropertyExplicitlySet("field")) {
                this.field(model.getField());
            }
            if (model.wasPropertyExplicitlySet("parserFieldId")) {
                this.parserFieldId(model.getParserFieldId());
            }
            if (model.wasPropertyExplicitlySet("parserFieldExpression")) {
                this.parserFieldExpression(model.getParserFieldExpression());
            }
            if (model.wasPropertyExplicitlySet("parserFieldName")) {
                this.parserFieldName(model.getParserFieldName());
            }
            if (model.wasPropertyExplicitlySet("storageFieldName")) {
                this.storageFieldName(model.getStorageFieldName());
            }
            if (model.wasPropertyExplicitlySet("parserFieldIntegratorName")) {
                this.parserFieldIntegratorName(model.getParserFieldIntegratorName());
            }
            if (model.wasPropertyExplicitlySet("parserName")) {
                this.parserName(model.getParserName());
            }
            if (model.wasPropertyExplicitlySet("parserFieldSequence")) {
                this.parserFieldSequence(model.getParserFieldSequence());
            }
            if (model.wasPropertyExplicitlySet("parser")) {
                this.parser(model.getParser());
            }
            if (model.wasPropertyExplicitlySet("structuredColumnInfo")) {
                this.structuredColumnInfo(model.getStructuredColumnInfo());
            }
            return this;
        }
    }
}

