/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsLabelAlias
extends ExplicitlySetBmcModel {
    @JsonProperty(value="alias")
    private final String alias;
    @JsonProperty(value="aliasDisplayName")
    private final String aliasDisplayName;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="priority")
    private final Priority priority;

    @Deprecated
    @ConstructorProperties(value={"alias", "aliasDisplayName", "isSystem", "displayName", "name", "priority"})
    public LogAnalyticsLabelAlias(String alias, String aliasDisplayName, Boolean isSystem, String displayName, String name, Priority priority) {
        this.alias = alias;
        this.aliasDisplayName = aliasDisplayName;
        this.isSystem = isSystem;
        this.displayName = displayName;
        this.name = name;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAliasDisplayName() {
        return this.aliasDisplayName;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsLabelAlias(");
        sb.append("super=").append(super.toString());
        sb.append("alias=").append(String.valueOf(this.alias));
        sb.append(", aliasDisplayName=").append(String.valueOf(this.aliasDisplayName));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", priority=").append(String.valueOf((Object)this.priority));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsLabelAlias)) {
            return false;
        }
        LogAnalyticsLabelAlias other = (LogAnalyticsLabelAlias)((Object)o);
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.aliasDisplayName, other.aliasDisplayName) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.priority, (Object)other.priority) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + (this.aliasDisplayName == null ? 43 : this.aliasDisplayName.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.priority == null ? 43 : this.priority.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Priority implements BmcEnum
    {
        None("NONE"),
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Priority> map;

        private Priority(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Priority create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Priority', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Priority.class);
            map = new HashMap<String, Priority>();
            for (Priority v : Priority.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="aliasDisplayName")
        private String aliasDisplayName;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="priority")
        private Priority priority;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder aliasDisplayName(String aliasDisplayName) {
            this.aliasDisplayName = aliasDisplayName;
            this.__explicitlySet__.add("aliasDisplayName");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            this.__explicitlySet__.add("priority");
            return this;
        }

        public LogAnalyticsLabelAlias build() {
            LogAnalyticsLabelAlias model = new LogAnalyticsLabelAlias(this.alias, this.aliasDisplayName, this.isSystem, this.displayName, this.name, this.priority);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsLabelAlias model) {
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            if (model.wasPropertyExplicitlySet("aliasDisplayName")) {
                this.aliasDisplayName(model.getAliasDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("priority")) {
                this.priority(model.getPriority());
            }
            return this;
        }
    }
}

