/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsEmBridgeSummaryReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="activeEmBridgeCount")
    private final Integer activeEmBridgeCount;
    @JsonProperty(value="creatingEmBridgeCount")
    private final Integer creatingEmBridgeCount;
    @JsonProperty(value="needsAttentionEmBridgeCount")
    private final Integer needsAttentionEmBridgeCount;
    @JsonProperty(value="deletedEmBridgeCount")
    private final Integer deletedEmBridgeCount;
    @JsonProperty(value="totalEmBridgeCount")
    private final Integer totalEmBridgeCount;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "activeEmBridgeCount", "creatingEmBridgeCount", "needsAttentionEmBridgeCount", "deletedEmBridgeCount", "totalEmBridgeCount"})
    public LogAnalyticsEmBridgeSummaryReport(String compartmentId, Integer activeEmBridgeCount, Integer creatingEmBridgeCount, Integer needsAttentionEmBridgeCount, Integer deletedEmBridgeCount, Integer totalEmBridgeCount) {
        this.compartmentId = compartmentId;
        this.activeEmBridgeCount = activeEmBridgeCount;
        this.creatingEmBridgeCount = creatingEmBridgeCount;
        this.needsAttentionEmBridgeCount = needsAttentionEmBridgeCount;
        this.deletedEmBridgeCount = deletedEmBridgeCount;
        this.totalEmBridgeCount = totalEmBridgeCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getActiveEmBridgeCount() {
        return this.activeEmBridgeCount;
    }

    public Integer getCreatingEmBridgeCount() {
        return this.creatingEmBridgeCount;
    }

    public Integer getNeedsAttentionEmBridgeCount() {
        return this.needsAttentionEmBridgeCount;
    }

    public Integer getDeletedEmBridgeCount() {
        return this.deletedEmBridgeCount;
    }

    public Integer getTotalEmBridgeCount() {
        return this.totalEmBridgeCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsEmBridgeSummaryReport(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", activeEmBridgeCount=").append(String.valueOf(this.activeEmBridgeCount));
        sb.append(", creatingEmBridgeCount=").append(String.valueOf(this.creatingEmBridgeCount));
        sb.append(", needsAttentionEmBridgeCount=").append(String.valueOf(this.needsAttentionEmBridgeCount));
        sb.append(", deletedEmBridgeCount=").append(String.valueOf(this.deletedEmBridgeCount));
        sb.append(", totalEmBridgeCount=").append(String.valueOf(this.totalEmBridgeCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsEmBridgeSummaryReport)) {
            return false;
        }
        LogAnalyticsEmBridgeSummaryReport other = (LogAnalyticsEmBridgeSummaryReport)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.activeEmBridgeCount, other.activeEmBridgeCount) && Objects.equals(this.creatingEmBridgeCount, other.creatingEmBridgeCount) && Objects.equals(this.needsAttentionEmBridgeCount, other.needsAttentionEmBridgeCount) && Objects.equals(this.deletedEmBridgeCount, other.deletedEmBridgeCount) && Objects.equals(this.totalEmBridgeCount, other.totalEmBridgeCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.activeEmBridgeCount == null ? 43 : this.activeEmBridgeCount.hashCode());
        result = result * 59 + (this.creatingEmBridgeCount == null ? 43 : this.creatingEmBridgeCount.hashCode());
        result = result * 59 + (this.needsAttentionEmBridgeCount == null ? 43 : this.needsAttentionEmBridgeCount.hashCode());
        result = result * 59 + (this.deletedEmBridgeCount == null ? 43 : this.deletedEmBridgeCount.hashCode());
        result = result * 59 + (this.totalEmBridgeCount == null ? 43 : this.totalEmBridgeCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="activeEmBridgeCount")
        private Integer activeEmBridgeCount;
        @JsonProperty(value="creatingEmBridgeCount")
        private Integer creatingEmBridgeCount;
        @JsonProperty(value="needsAttentionEmBridgeCount")
        private Integer needsAttentionEmBridgeCount;
        @JsonProperty(value="deletedEmBridgeCount")
        private Integer deletedEmBridgeCount;
        @JsonProperty(value="totalEmBridgeCount")
        private Integer totalEmBridgeCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder activeEmBridgeCount(Integer activeEmBridgeCount) {
            this.activeEmBridgeCount = activeEmBridgeCount;
            this.__explicitlySet__.add("activeEmBridgeCount");
            return this;
        }

        public Builder creatingEmBridgeCount(Integer creatingEmBridgeCount) {
            this.creatingEmBridgeCount = creatingEmBridgeCount;
            this.__explicitlySet__.add("creatingEmBridgeCount");
            return this;
        }

        public Builder needsAttentionEmBridgeCount(Integer needsAttentionEmBridgeCount) {
            this.needsAttentionEmBridgeCount = needsAttentionEmBridgeCount;
            this.__explicitlySet__.add("needsAttentionEmBridgeCount");
            return this;
        }

        public Builder deletedEmBridgeCount(Integer deletedEmBridgeCount) {
            this.deletedEmBridgeCount = deletedEmBridgeCount;
            this.__explicitlySet__.add("deletedEmBridgeCount");
            return this;
        }

        public Builder totalEmBridgeCount(Integer totalEmBridgeCount) {
            this.totalEmBridgeCount = totalEmBridgeCount;
            this.__explicitlySet__.add("totalEmBridgeCount");
            return this;
        }

        public LogAnalyticsEmBridgeSummaryReport build() {
            LogAnalyticsEmBridgeSummaryReport model = new LogAnalyticsEmBridgeSummaryReport(this.compartmentId, this.activeEmBridgeCount, this.creatingEmBridgeCount, this.needsAttentionEmBridgeCount, this.deletedEmBridgeCount, this.totalEmBridgeCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsEmBridgeSummaryReport model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("activeEmBridgeCount")) {
                this.activeEmBridgeCount(model.getActiveEmBridgeCount());
            }
            if (model.wasPropertyExplicitlySet("creatingEmBridgeCount")) {
                this.creatingEmBridgeCount(model.getCreatingEmBridgeCount());
            }
            if (model.wasPropertyExplicitlySet("needsAttentionEmBridgeCount")) {
                this.needsAttentionEmBridgeCount(model.getNeedsAttentionEmBridgeCount());
            }
            if (model.wasPropertyExplicitlySet("deletedEmBridgeCount")) {
                this.deletedEmBridgeCount(model.getDeletedEmBridgeCount());
            }
            if (model.wasPropertyExplicitlySet("totalEmBridgeCount")) {
                this.totalEmBridgeCount(model.getTotalEmBridgeCount());
            }
            return this;
        }
    }
}

