/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class HighlightRowsCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="color")
    private final String color;
    @JsonProperty(value="keywords")
    private final List<String> keywords;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HighlightRowsCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, String color, List<String> keywords) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.color = color;
        this.keywords = keywords;
    }

    public String getColor() {
        return this.color;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HighlightRowsCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", color=").append(String.valueOf(this.color));
        sb.append(", keywords=").append(String.valueOf(this.keywords));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HighlightRowsCommandDescriptor)) {
            return false;
        }
        HighlightRowsCommandDescriptor other = (HighlightRowsCommandDescriptor)((Object)o);
        return Objects.equals(this.color, other.color) && Objects.equals(this.keywords, other.keywords) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.color == null ? 43 : this.color.hashCode());
        result = result * 59 + (this.keywords == null ? 43 : this.keywords.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="color")
        private String color;
        @JsonProperty(value="keywords")
        private List<String> keywords;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.__explicitlySet__.add("color");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.__explicitlySet__.add("keywords");
            return this;
        }

        public HighlightRowsCommandDescriptor build() {
            HighlightRowsCommandDescriptor model = new HighlightRowsCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.color, this.keywords);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HighlightRowsCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("color")) {
                this.color(model.getColor());
            }
            if (model.wasPropertyExplicitlySet("keywords")) {
                this.keywords(model.getKeywords());
            }
            return this;
        }
    }
}

