/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.ParseQueryOutput;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class HighlightGroupsCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="color")
    private final String color;
    @JsonProperty(value="priority")
    private final String priority;
    @JsonProperty(value="matchOnly")
    private final List<String> matchOnly;
    @JsonProperty(value="fields")
    private final List<String> fields;
    @JsonProperty(value="keywords")
    private final List<String> keywords;
    @JsonProperty(value="subQueries")
    private final List<ParseQueryOutput> subQueries;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HighlightGroupsCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, String color, String priority, List<String> matchOnly, List<String> fields, List<String> keywords, List<ParseQueryOutput> subQueries) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.color = color;
        this.priority = priority;
        this.matchOnly = matchOnly;
        this.fields = fields;
        this.keywords = keywords;
        this.subQueries = subQueries;
    }

    public String getColor() {
        return this.color;
    }

    public String getPriority() {
        return this.priority;
    }

    public List<String> getMatchOnly() {
        return this.matchOnly;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<ParseQueryOutput> getSubQueries() {
        return this.subQueries;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HighlightGroupsCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", color=").append(String.valueOf(this.color));
        sb.append(", priority=").append(String.valueOf(this.priority));
        sb.append(", matchOnly=").append(String.valueOf(this.matchOnly));
        sb.append(", fields=").append(String.valueOf(this.fields));
        sb.append(", keywords=").append(String.valueOf(this.keywords));
        sb.append(", subQueries=").append(String.valueOf(this.subQueries));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HighlightGroupsCommandDescriptor)) {
            return false;
        }
        HighlightGroupsCommandDescriptor other = (HighlightGroupsCommandDescriptor)((Object)o);
        return Objects.equals(this.color, other.color) && Objects.equals(this.priority, other.priority) && Objects.equals(this.matchOnly, other.matchOnly) && Objects.equals(this.fields, other.fields) && Objects.equals(this.keywords, other.keywords) && Objects.equals(this.subQueries, other.subQueries) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.color == null ? 43 : this.color.hashCode());
        result = result * 59 + (this.priority == null ? 43 : this.priority.hashCode());
        result = result * 59 + (this.matchOnly == null ? 43 : this.matchOnly.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.keywords == null ? 43 : this.keywords.hashCode());
        result = result * 59 + (this.subQueries == null ? 43 : this.subQueries.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="color")
        private String color;
        @JsonProperty(value="priority")
        private String priority;
        @JsonProperty(value="matchOnly")
        private List<String> matchOnly;
        @JsonProperty(value="fields")
        private List<String> fields;
        @JsonProperty(value="keywords")
        private List<String> keywords;
        @JsonProperty(value="subQueries")
        private List<ParseQueryOutput> subQueries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.__explicitlySet__.add("color");
            return this;
        }

        public Builder priority(String priority) {
            this.priority = priority;
            this.__explicitlySet__.add("priority");
            return this;
        }

        public Builder matchOnly(List<String> matchOnly) {
            this.matchOnly = matchOnly;
            this.__explicitlySet__.add("matchOnly");
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            this.__explicitlySet__.add("fields");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.__explicitlySet__.add("keywords");
            return this;
        }

        public Builder subQueries(List<ParseQueryOutput> subQueries) {
            this.subQueries = subQueries;
            this.__explicitlySet__.add("subQueries");
            return this;
        }

        public HighlightGroupsCommandDescriptor build() {
            HighlightGroupsCommandDescriptor model = new HighlightGroupsCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.color, this.priority, this.matchOnly, this.fields, this.keywords, this.subQueries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HighlightGroupsCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("color")) {
                this.color(model.getColor());
            }
            if (model.wasPropertyExplicitlySet("priority")) {
                this.priority(model.getPriority());
            }
            if (model.wasPropertyExplicitlySet("matchOnly")) {
                this.matchOnly(model.getMatchOnly());
            }
            if (model.wasPropertyExplicitlySet("fields")) {
                this.fields(model.getFields());
            }
            if (model.wasPropertyExplicitlySet("keywords")) {
                this.keywords(model.getKeywords());
            }
            if (model.wasPropertyExplicitlySet("subQueries")) {
                this.subQueries(model.getSubQueries());
            }
            return this;
        }
    }
}

