/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.FunctionField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class GeoStatsCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="include")
    private final Include include;
    @JsonProperty(value="cityField")
    private final AbstractField cityField;
    @JsonProperty(value="regionField")
    private final AbstractField regionField;
    @JsonProperty(value="countryField")
    private final AbstractField countryField;
    @JsonProperty(value="continentField")
    private final AbstractField continentField;
    @JsonProperty(value="coordinatesField")
    private final AbstractField coordinatesField;
    @JsonProperty(value="groupByFields")
    private final List<AbstractField> groupByFields;
    @JsonProperty(value="functions")
    private final List<FunctionField> functions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GeoStatsCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, Include include, AbstractField cityField, AbstractField regionField, AbstractField countryField, AbstractField continentField, AbstractField coordinatesField, List<AbstractField> groupByFields, List<FunctionField> functions) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.include = include;
        this.cityField = cityField;
        this.regionField = regionField;
        this.countryField = countryField;
        this.continentField = continentField;
        this.coordinatesField = coordinatesField;
        this.groupByFields = groupByFields;
        this.functions = functions;
    }

    public Include getInclude() {
        return this.include;
    }

    public AbstractField getCityField() {
        return this.cityField;
    }

    public AbstractField getRegionField() {
        return this.regionField;
    }

    public AbstractField getCountryField() {
        return this.countryField;
    }

    public AbstractField getContinentField() {
        return this.continentField;
    }

    public AbstractField getCoordinatesField() {
        return this.coordinatesField;
    }

    public List<AbstractField> getGroupByFields() {
        return this.groupByFields;
    }

    public List<FunctionField> getFunctions() {
        return this.functions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GeoStatsCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", include=").append(String.valueOf((Object)this.include));
        sb.append(", cityField=").append(String.valueOf((Object)this.cityField));
        sb.append(", regionField=").append(String.valueOf((Object)this.regionField));
        sb.append(", countryField=").append(String.valueOf((Object)this.countryField));
        sb.append(", continentField=").append(String.valueOf((Object)this.continentField));
        sb.append(", coordinatesField=").append(String.valueOf((Object)this.coordinatesField));
        sb.append(", groupByFields=").append(String.valueOf(this.groupByFields));
        sb.append(", functions=").append(String.valueOf(this.functions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoStatsCommandDescriptor)) {
            return false;
        }
        GeoStatsCommandDescriptor other = (GeoStatsCommandDescriptor)((Object)o);
        return Objects.equals((Object)this.include, (Object)other.include) && Objects.equals((Object)this.cityField, (Object)other.cityField) && Objects.equals((Object)this.regionField, (Object)other.regionField) && Objects.equals((Object)this.countryField, (Object)other.countryField) && Objects.equals((Object)this.continentField, (Object)other.continentField) && Objects.equals((Object)this.coordinatesField, (Object)other.coordinatesField) && Objects.equals(this.groupByFields, other.groupByFields) && Objects.equals(this.functions, other.functions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.include == null ? 43 : this.include.hashCode());
        result = result * 59 + (this.cityField == null ? 43 : this.cityField.hashCode());
        result = result * 59 + (this.regionField == null ? 43 : this.regionField.hashCode());
        result = result * 59 + (this.countryField == null ? 43 : this.countryField.hashCode());
        result = result * 59 + (this.continentField == null ? 43 : this.continentField.hashCode());
        result = result * 59 + (this.coordinatesField == null ? 43 : this.coordinatesField.hashCode());
        result = result * 59 + (this.groupByFields == null ? 43 : this.groupByFields.hashCode());
        result = result * 59 + (this.functions == null ? 43 : this.functions.hashCode());
        return result;
    }

    public static enum Include implements BmcEnum
    {
        Client("CLIENT"),
        Server("SERVER"),
        ClientAndServer("CLIENT_AND_SERVER"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Include> map;

        private Include(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Include create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Include', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Include.class);
            map = new HashMap<String, Include>();
            for (Include v : Include.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="include")
        private Include include;
        @JsonProperty(value="cityField")
        private AbstractField cityField;
        @JsonProperty(value="regionField")
        private AbstractField regionField;
        @JsonProperty(value="countryField")
        private AbstractField countryField;
        @JsonProperty(value="continentField")
        private AbstractField continentField;
        @JsonProperty(value="coordinatesField")
        private AbstractField coordinatesField;
        @JsonProperty(value="groupByFields")
        private List<AbstractField> groupByFields;
        @JsonProperty(value="functions")
        private List<FunctionField> functions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder include(Include include) {
            this.include = include;
            this.__explicitlySet__.add("include");
            return this;
        }

        public Builder cityField(AbstractField cityField) {
            this.cityField = cityField;
            this.__explicitlySet__.add("cityField");
            return this;
        }

        public Builder regionField(AbstractField regionField) {
            this.regionField = regionField;
            this.__explicitlySet__.add("regionField");
            return this;
        }

        public Builder countryField(AbstractField countryField) {
            this.countryField = countryField;
            this.__explicitlySet__.add("countryField");
            return this;
        }

        public Builder continentField(AbstractField continentField) {
            this.continentField = continentField;
            this.__explicitlySet__.add("continentField");
            return this;
        }

        public Builder coordinatesField(AbstractField coordinatesField) {
            this.coordinatesField = coordinatesField;
            this.__explicitlySet__.add("coordinatesField");
            return this;
        }

        public Builder groupByFields(List<AbstractField> groupByFields) {
            this.groupByFields = groupByFields;
            this.__explicitlySet__.add("groupByFields");
            return this;
        }

        public Builder functions(List<FunctionField> functions) {
            this.functions = functions;
            this.__explicitlySet__.add("functions");
            return this;
        }

        public GeoStatsCommandDescriptor build() {
            GeoStatsCommandDescriptor model = new GeoStatsCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.include, this.cityField, this.regionField, this.countryField, this.continentField, this.coordinatesField, this.groupByFields, this.functions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GeoStatsCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("include")) {
                this.include(model.getInclude());
            }
            if (model.wasPropertyExplicitlySet("cityField")) {
                this.cityField(model.getCityField());
            }
            if (model.wasPropertyExplicitlySet("regionField")) {
                this.regionField(model.getRegionField());
            }
            if (model.wasPropertyExplicitlySet("countryField")) {
                this.countryField(model.getCountryField());
            }
            if (model.wasPropertyExplicitlySet("continentField")) {
                this.continentField(model.getContinentField());
            }
            if (model.wasPropertyExplicitlySet("coordinatesField")) {
                this.coordinatesField(model.getCoordinatesField());
            }
            if (model.wasPropertyExplicitlySet("groupByFields")) {
                this.groupByFields(model.getGroupByFields());
            }
            if (model.wasPropertyExplicitlySet("functions")) {
                this.functions(model.getFunctions());
            }
            return this;
        }
    }
}

