/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.Schedule;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class FixedFrequencySchedule
extends Schedule {
    @JsonProperty(value="recurringInterval")
    private final String recurringInterval;
    @JsonProperty(value="repeatCount")
    private final Integer repeatCount;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FixedFrequencySchedule(Schedule.MisfirePolicy misfirePolicy, Date timeOfFirstExecution, String recurringInterval, Integer repeatCount) {
        super(misfirePolicy, timeOfFirstExecution);
        this.recurringInterval = recurringInterval;
        this.repeatCount = repeatCount;
    }

    public String getRecurringInterval() {
        return this.recurringInterval;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FixedFrequencySchedule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", recurringInterval=").append(String.valueOf(this.recurringInterval));
        sb.append(", repeatCount=").append(String.valueOf(this.repeatCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedFrequencySchedule)) {
            return false;
        }
        FixedFrequencySchedule other = (FixedFrequencySchedule)((Object)o);
        return Objects.equals(this.recurringInterval, other.recurringInterval) && Objects.equals(this.repeatCount, other.repeatCount) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recurringInterval == null ? 43 : this.recurringInterval.hashCode());
        result = result * 59 + (this.repeatCount == null ? 43 : this.repeatCount.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="misfirePolicy")
        private Schedule.MisfirePolicy misfirePolicy;
        @JsonProperty(value="timeOfFirstExecution")
        private Date timeOfFirstExecution;
        @JsonProperty(value="recurringInterval")
        private String recurringInterval;
        @JsonProperty(value="repeatCount")
        private Integer repeatCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder misfirePolicy(Schedule.MisfirePolicy misfirePolicy) {
            this.misfirePolicy = misfirePolicy;
            this.__explicitlySet__.add("misfirePolicy");
            return this;
        }

        public Builder timeOfFirstExecution(Date timeOfFirstExecution) {
            this.timeOfFirstExecution = timeOfFirstExecution;
            this.__explicitlySet__.add("timeOfFirstExecution");
            return this;
        }

        public Builder recurringInterval(String recurringInterval) {
            this.recurringInterval = recurringInterval;
            this.__explicitlySet__.add("recurringInterval");
            return this;
        }

        public Builder repeatCount(Integer repeatCount) {
            this.repeatCount = repeatCount;
            this.__explicitlySet__.add("repeatCount");
            return this;
        }

        public FixedFrequencySchedule build() {
            FixedFrequencySchedule model = new FixedFrequencySchedule(this.misfirePolicy, this.timeOfFirstExecution, this.recurringInterval, this.repeatCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FixedFrequencySchedule model) {
            if (model.wasPropertyExplicitlySet("misfirePolicy")) {
                this.misfirePolicy(model.getMisfirePolicy());
            }
            if (model.wasPropertyExplicitlySet("timeOfFirstExecution")) {
                this.timeOfFirstExecution(model.getTimeOfFirstExecution());
            }
            if (model.wasPropertyExplicitlySet("recurringInterval")) {
                this.recurringInterval(model.getRecurringInterval());
            }
            if (model.wasPropertyExplicitlySet("repeatCount")) {
                this.repeatCount(model.getRepeatCount());
            }
            return this;
        }
    }
}

