/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class FieldsAddRemoveField
extends AbstractField {
    @JsonProperty(value="operation")
    private final Operation operation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FieldsAddRemoveField(String displayName, Boolean isDeclared, List<String> originalDisplayNames, String internalName, ValueType valueType, Boolean isGroupable, Boolean isDuration, String alias, String filterQueryString, String unitType, Operation operation) {
        super(displayName, isDeclared, originalDisplayNames, internalName, valueType, isGroupable, isDuration, alias, filterQueryString, unitType);
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldsAddRemoveField(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", operation=").append(String.valueOf((Object)this.operation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldsAddRemoveField)) {
            return false;
        }
        FieldsAddRemoveField other = (FieldsAddRemoveField)((Object)o);
        return Objects.equals((Object)this.operation, (Object)other.operation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        return result;
    }

    public static enum Operation implements BmcEnum
    {
        Add("ADD"),
        Remove("REMOVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operation> map;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operation.class);
            map = new HashMap<String, Operation>();
            for (Operation v : Operation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="isDeclared")
        private Boolean isDeclared;
        @JsonProperty(value="originalDisplayNames")
        private List<String> originalDisplayNames;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isDuration")
        private Boolean isDuration;
        @JsonProperty(value="alias")
        private String alias;
        @JsonProperty(value="filterQueryString")
        private String filterQueryString;
        @JsonProperty(value="unitType")
        private String unitType;
        @JsonProperty(value="operation")
        private Operation operation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder isDeclared(Boolean isDeclared) {
            this.isDeclared = isDeclared;
            this.__explicitlySet__.add("isDeclared");
            return this;
        }

        public Builder originalDisplayNames(List<String> originalDisplayNames) {
            this.originalDisplayNames = originalDisplayNames;
            this.__explicitlySet__.add("originalDisplayNames");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isDuration(Boolean isDuration) {
            this.isDuration = isDuration;
            this.__explicitlySet__.add("isDuration");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public Builder filterQueryString(String filterQueryString) {
            this.filterQueryString = filterQueryString;
            this.__explicitlySet__.add("filterQueryString");
            return this;
        }

        public Builder unitType(String unitType) {
            this.unitType = unitType;
            this.__explicitlySet__.add("unitType");
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public FieldsAddRemoveField build() {
            FieldsAddRemoveField model = new FieldsAddRemoveField(this.displayName, this.isDeclared, this.originalDisplayNames, this.internalName, this.valueType, this.isGroupable, this.isDuration, this.alias, this.filterQueryString, this.unitType, this.operation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FieldsAddRemoveField model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("isDeclared")) {
                this.isDeclared(model.getIsDeclared());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayNames")) {
                this.originalDisplayNames(model.getOriginalDisplayNames());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isDuration")) {
                this.isDuration(model.getIsDuration());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            if (model.wasPropertyExplicitlySet("filterQueryString")) {
                this.filterQueryString(model.getFilterQueryString());
            }
            if (model.wasPropertyExplicitlySet("unitType")) {
                this.unitType(model.getUnitType());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            return this;
        }
    }
}

