/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.EncryptionKeySource;
import com.oracle.bmc.loganalytics.model.EncryptionKeyType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EncryptionKeyInfoSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keySource")
    private final EncryptionKeySource keySource;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyType")
    private final EncryptionKeyType keyType;

    @Deprecated
    @ConstructorProperties(value={"keySource", "keyId", "keyType"})
    public EncryptionKeyInfoSummary(EncryptionKeySource keySource, String keyId, EncryptionKeyType keyType) {
        this.keySource = keySource;
        this.keyId = keyId;
        this.keyType = keyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public EncryptionKeySource getKeySource() {
        return this.keySource;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public EncryptionKeyType getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptionKeyInfoSummary(");
        sb.append("super=").append(super.toString());
        sb.append("keySource=").append(String.valueOf((Object)this.keySource));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", keyType=").append(String.valueOf((Object)this.keyType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionKeyInfoSummary)) {
            return false;
        }
        EncryptionKeyInfoSummary other = (EncryptionKeyInfoSummary)((Object)o);
        return Objects.equals((Object)this.keySource, (Object)other.keySource) && Objects.equals(this.keyId, other.keyId) && Objects.equals((Object)this.keyType, (Object)other.keyType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keySource == null ? 43 : this.keySource.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.keyType == null ? 43 : this.keyType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keySource")
        private EncryptionKeySource keySource;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyType")
        private EncryptionKeyType keyType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keySource(EncryptionKeySource keySource) {
            this.keySource = keySource;
            this.__explicitlySet__.add("keySource");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyType(EncryptionKeyType keyType) {
            this.keyType = keyType;
            this.__explicitlySet__.add("keyType");
            return this;
        }

        public EncryptionKeyInfoSummary build() {
            EncryptionKeyInfoSummary model = new EncryptionKeyInfoSummary(this.keySource, this.keyId, this.keyType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EncryptionKeyInfoSummary model) {
            if (model.wasPropertyExplicitlySet("keySource")) {
                this.keySource(model.getKeySource());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("keyType")) {
                this.keyType(model.getKeyType());
            }
            return this;
        }
    }
}

