/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CompareLineResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="leftContent")
    private final String leftContent;
    @JsonProperty(value="rightContent")
    private final String rightContent;
    @JsonProperty(value="diffType")
    private final String diffType;
    @JsonProperty(value="leftIndices")
    private final String leftIndices;
    @JsonProperty(value="rightIndices")
    private final String rightIndices;

    @Deprecated
    @ConstructorProperties(value={"leftContent", "rightContent", "diffType", "leftIndices", "rightIndices"})
    public CompareLineResult(String leftContent, String rightContent, String diffType, String leftIndices, String rightIndices) {
        this.leftContent = leftContent;
        this.rightContent = rightContent;
        this.diffType = diffType;
        this.leftIndices = leftIndices;
        this.rightIndices = rightIndices;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLeftContent() {
        return this.leftContent;
    }

    public String getRightContent() {
        return this.rightContent;
    }

    public String getDiffType() {
        return this.diffType;
    }

    public String getLeftIndices() {
        return this.leftIndices;
    }

    public String getRightIndices() {
        return this.rightIndices;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CompareLineResult(");
        sb.append("super=").append(super.toString());
        sb.append("leftContent=").append(String.valueOf(this.leftContent));
        sb.append(", rightContent=").append(String.valueOf(this.rightContent));
        sb.append(", diffType=").append(String.valueOf(this.diffType));
        sb.append(", leftIndices=").append(String.valueOf(this.leftIndices));
        sb.append(", rightIndices=").append(String.valueOf(this.rightIndices));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompareLineResult)) {
            return false;
        }
        CompareLineResult other = (CompareLineResult)((Object)o);
        return Objects.equals(this.leftContent, other.leftContent) && Objects.equals(this.rightContent, other.rightContent) && Objects.equals(this.diffType, other.diffType) && Objects.equals(this.leftIndices, other.leftIndices) && Objects.equals(this.rightIndices, other.rightIndices) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.leftContent == null ? 43 : this.leftContent.hashCode());
        result = result * 59 + (this.rightContent == null ? 43 : this.rightContent.hashCode());
        result = result * 59 + (this.diffType == null ? 43 : this.diffType.hashCode());
        result = result * 59 + (this.leftIndices == null ? 43 : this.leftIndices.hashCode());
        result = result * 59 + (this.rightIndices == null ? 43 : this.rightIndices.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="leftContent")
        private String leftContent;
        @JsonProperty(value="rightContent")
        private String rightContent;
        @JsonProperty(value="diffType")
        private String diffType;
        @JsonProperty(value="leftIndices")
        private String leftIndices;
        @JsonProperty(value="rightIndices")
        private String rightIndices;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder leftContent(String leftContent) {
            this.leftContent = leftContent;
            this.__explicitlySet__.add("leftContent");
            return this;
        }

        public Builder rightContent(String rightContent) {
            this.rightContent = rightContent;
            this.__explicitlySet__.add("rightContent");
            return this;
        }

        public Builder diffType(String diffType) {
            this.diffType = diffType;
            this.__explicitlySet__.add("diffType");
            return this;
        }

        public Builder leftIndices(String leftIndices) {
            this.leftIndices = leftIndices;
            this.__explicitlySet__.add("leftIndices");
            return this;
        }

        public Builder rightIndices(String rightIndices) {
            this.rightIndices = rightIndices;
            this.__explicitlySet__.add("rightIndices");
            return this;
        }

        public CompareLineResult build() {
            CompareLineResult model = new CompareLineResult(this.leftContent, this.rightContent, this.diffType, this.leftIndices, this.rightIndices);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CompareLineResult model) {
            if (model.wasPropertyExplicitlySet("leftContent")) {
                this.leftContent(model.getLeftContent());
            }
            if (model.wasPropertyExplicitlySet("rightContent")) {
                this.rightContent(model.getRightContent());
            }
            if (model.wasPropertyExplicitlySet("diffType")) {
                this.diffType(model.getDiffType());
            }
            if (model.wasPropertyExplicitlySet("leftIndices")) {
                this.leftIndices(model.getLeftIndices());
            }
            if (model.wasPropertyExplicitlySet("rightIndices")) {
                this.rightIndices(model.getRightIndices());
            }
            return this;
        }
    }
}

