/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.lockbox.model.AccessRequestActionType;
import com.oracle.bmc.lockbox.model.PersonaLevel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ActivityLog
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="userLevel")
    private final PersonaLevel userLevel;
    @JsonProperty(value="action")
    private final AccessRequestActionType action;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"userId", "userLevel", "action", "message", "timeUpdated"})
    public ActivityLog(String userId, PersonaLevel userLevel, AccessRequestActionType action, String message, Date timeUpdated) {
        this.userId = userId;
        this.userLevel = userLevel;
        this.action = action;
        this.message = message;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUserId() {
        return this.userId;
    }

    public PersonaLevel getUserLevel() {
        return this.userLevel;
    }

    public AccessRequestActionType getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActivityLog(");
        sb.append("super=").append(super.toString());
        sb.append("userId=").append(String.valueOf(this.userId));
        sb.append(", userLevel=").append(String.valueOf((Object)this.userLevel));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityLog)) {
            return false;
        }
        ActivityLog other = (ActivityLog)((Object)o);
        return Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.userLevel, (Object)other.userLevel) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.message, other.message) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.userLevel == null ? 43 : this.userLevel.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="userLevel")
        private PersonaLevel userLevel;
        @JsonProperty(value="action")
        private AccessRequestActionType action;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder userLevel(PersonaLevel userLevel) {
            this.userLevel = userLevel;
            this.__explicitlySet__.add("userLevel");
            return this;
        }

        public Builder action(AccessRequestActionType action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public ActivityLog build() {
            ActivityLog model = new ActivityLog(this.userId, this.userLevel, this.action, this.message, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActivityLog model) {
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("userLevel")) {
                this.userLevel(model.getUserLevel());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

