/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox;

import com.oracle.bmc.lockbox.Lockbox;
import com.oracle.bmc.lockbox.model.AccessRequestSummary;
import com.oracle.bmc.lockbox.model.ApprovalTemplateSummary;
import com.oracle.bmc.lockbox.model.LockboxSummary;
import com.oracle.bmc.lockbox.model.WorkRequestError;
import com.oracle.bmc.lockbox.model.WorkRequestLogEntry;
import com.oracle.bmc.lockbox.model.WorkRequestSummary;
import com.oracle.bmc.lockbox.requests.ListAccessRequestsRequest;
import com.oracle.bmc.lockbox.requests.ListApprovalTemplatesRequest;
import com.oracle.bmc.lockbox.requests.ListLockboxesRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.lockbox.requests.ListWorkRequestsRequest;
import com.oracle.bmc.lockbox.responses.ListAccessRequestsResponse;
import com.oracle.bmc.lockbox.responses.ListApprovalTemplatesResponse;
import com.oracle.bmc.lockbox.responses.ListLockboxesResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.lockbox.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class LockboxPaginators {
    private final Lockbox client;

    public LockboxPaginators(Lockbox client) {
        this.client = client;
    }

    public Iterable<ListAccessRequestsResponse> listAccessRequestsResponseIterator(final ListAccessRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAccessRequestsRequest.Builder>(){

            @Override
            public ListAccessRequestsRequest.Builder get() {
                return ListAccessRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, String>(){

            @Override
            public String apply(ListAccessRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestsRequest.Builder>, ListAccessRequestsRequest>(){

            @Override
            public ListAccessRequestsRequest apply(RequestBuilderAndToken<ListAccessRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestsRequest, ListAccessRequestsResponse>(){

            @Override
            public ListAccessRequestsResponse apply(ListAccessRequestsRequest request) {
                return LockboxPaginators.this.client.listAccessRequests(request);
            }
        });
    }

    public Iterable<AccessRequestSummary> listAccessRequestsRecordIterator(final ListAccessRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAccessRequestsRequest.Builder>(){

            @Override
            public ListAccessRequestsRequest.Builder get() {
                return ListAccessRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, String>(){

            @Override
            public String apply(ListAccessRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAccessRequestsRequest.Builder>, ListAccessRequestsRequest>(){

            @Override
            public ListAccessRequestsRequest apply(RequestBuilderAndToken<ListAccessRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAccessRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAccessRequestsRequest, ListAccessRequestsResponse>(){

            @Override
            public ListAccessRequestsResponse apply(ListAccessRequestsRequest request) {
                return LockboxPaginators.this.client.listAccessRequests(request);
            }
        }, (Function)new Function<ListAccessRequestsResponse, List<AccessRequestSummary>>(){

            @Override
            public List<AccessRequestSummary> apply(ListAccessRequestsResponse response) {
                return response.getAccessRequestCollection().getItems();
            }
        });
    }

    public Iterable<ListApprovalTemplatesResponse> listApprovalTemplatesResponseIterator(final ListApprovalTemplatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApprovalTemplatesRequest.Builder>(){

            @Override
            public ListApprovalTemplatesRequest.Builder get() {
                return ListApprovalTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApprovalTemplatesResponse, String>(){

            @Override
            public String apply(ListApprovalTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApprovalTemplatesRequest.Builder>, ListApprovalTemplatesRequest>(){

            @Override
            public ListApprovalTemplatesRequest apply(RequestBuilderAndToken<ListApprovalTemplatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApprovalTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApprovalTemplatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApprovalTemplatesRequest, ListApprovalTemplatesResponse>(){

            @Override
            public ListApprovalTemplatesResponse apply(ListApprovalTemplatesRequest request) {
                return LockboxPaginators.this.client.listApprovalTemplates(request);
            }
        });
    }

    public Iterable<ApprovalTemplateSummary> listApprovalTemplatesRecordIterator(final ListApprovalTemplatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApprovalTemplatesRequest.Builder>(){

            @Override
            public ListApprovalTemplatesRequest.Builder get() {
                return ListApprovalTemplatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApprovalTemplatesResponse, String>(){

            @Override
            public String apply(ListApprovalTemplatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApprovalTemplatesRequest.Builder>, ListApprovalTemplatesRequest>(){

            @Override
            public ListApprovalTemplatesRequest apply(RequestBuilderAndToken<ListApprovalTemplatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApprovalTemplatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApprovalTemplatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApprovalTemplatesRequest, ListApprovalTemplatesResponse>(){

            @Override
            public ListApprovalTemplatesResponse apply(ListApprovalTemplatesRequest request) {
                return LockboxPaginators.this.client.listApprovalTemplates(request);
            }
        }, (Function)new Function<ListApprovalTemplatesResponse, List<ApprovalTemplateSummary>>(){

            @Override
            public List<ApprovalTemplateSummary> apply(ListApprovalTemplatesResponse response) {
                return response.getApprovalTemplateCollection().getItems();
            }
        });
    }

    public Iterable<ListLockboxesResponse> listLockboxesResponseIterator(final ListLockboxesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLockboxesRequest.Builder>(){

            @Override
            public ListLockboxesRequest.Builder get() {
                return ListLockboxesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLockboxesResponse, String>(){

            @Override
            public String apply(ListLockboxesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLockboxesRequest.Builder>, ListLockboxesRequest>(){

            @Override
            public ListLockboxesRequest apply(RequestBuilderAndToken<ListLockboxesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLockboxesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLockboxesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLockboxesRequest, ListLockboxesResponse>(){

            @Override
            public ListLockboxesResponse apply(ListLockboxesRequest request) {
                return LockboxPaginators.this.client.listLockboxes(request);
            }
        });
    }

    public Iterable<LockboxSummary> listLockboxesRecordIterator(final ListLockboxesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLockboxesRequest.Builder>(){

            @Override
            public ListLockboxesRequest.Builder get() {
                return ListLockboxesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLockboxesResponse, String>(){

            @Override
            public String apply(ListLockboxesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLockboxesRequest.Builder>, ListLockboxesRequest>(){

            @Override
            public ListLockboxesRequest apply(RequestBuilderAndToken<ListLockboxesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListLockboxesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLockboxesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListLockboxesRequest, ListLockboxesResponse>(){

            @Override
            public ListLockboxesResponse apply(ListLockboxesRequest request) {
                return LockboxPaginators.this.client.listLockboxes(request);
            }
        }, (Function)new Function<ListLockboxesResponse, List<LockboxSummary>>(){

            @Override
            public List<LockboxSummary> apply(ListLockboxesResponse response) {
                return response.getLockboxCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return LockboxPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return LockboxPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return LockboxPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return LockboxPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LockboxPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LockboxPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

