/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loadbalancer.model.CreateLoadBalancerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateLoadBalancerRequest
extends BmcRequest<CreateLoadBalancerDetails> {
    private CreateLoadBalancerDetails createLoadBalancerDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateLoadBalancerDetails getCreateLoadBalancerDetails() {
        return this.createLoadBalancerDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateLoadBalancerDetails getBody$() {
        return this.createLoadBalancerDetails;
    }

    public Builder toBuilder() {
        return new Builder().createLoadBalancerDetails(this.createLoadBalancerDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createLoadBalancerDetails=").append(String.valueOf((Object)this.createLoadBalancerDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createLoadBalancerDetails, (Object)other.createLoadBalancerDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createLoadBalancerDetails == null ? 43 : this.createLoadBalancerDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateLoadBalancerRequest, CreateLoadBalancerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateLoadBalancerDetails createLoadBalancerDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createLoadBalancerDetails(CreateLoadBalancerDetails createLoadBalancerDetails) {
            this.createLoadBalancerDetails = createLoadBalancerDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateLoadBalancerRequest o) {
            this.createLoadBalancerDetails(o.getCreateLoadBalancerDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateLoadBalancerRequest build() {
            CreateLoadBalancerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateLoadBalancerDetails body) {
            this.createLoadBalancerDetails(body);
            return this;
        }

        public CreateLoadBalancerRequest buildWithoutInvocationCallback() {
            CreateLoadBalancerRequest request = new CreateLoadBalancerRequest();
            request.createLoadBalancerDetails = this.createLoadBalancerDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

