/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loadbalancer.model.RedirectUri;
import com.oracle.bmc.loadbalancer.model.Rule;
import com.oracle.bmc.loadbalancer.model.RuleCondition;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class RedirectRule
extends Rule {
    @JsonProperty(value="responseCode")
    private final Integer responseCode;
    @JsonProperty(value="conditions")
    private final List<RuleCondition> conditions;
    @JsonProperty(value="redirectUri")
    private final RedirectUri redirectUri;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RedirectRule(Integer responseCode, List<RuleCondition> conditions, RedirectUri redirectUri) {
        this.responseCode = responseCode;
        this.conditions = conditions;
        this.redirectUri = redirectUri;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public RedirectUri getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RedirectRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", responseCode=").append(String.valueOf(this.responseCode));
        sb.append(", conditions=").append(String.valueOf(this.conditions));
        sb.append(", redirectUri=").append(String.valueOf((Object)this.redirectUri));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedirectRule)) {
            return false;
        }
        RedirectRule other = (RedirectRule)((Object)o);
        return Objects.equals(this.responseCode, other.responseCode) && Objects.equals(this.conditions, other.conditions) && Objects.equals((Object)this.redirectUri, (Object)other.redirectUri) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.responseCode == null ? 43 : this.responseCode.hashCode());
        result = result * 59 + (this.conditions == null ? 43 : this.conditions.hashCode());
        result = result * 59 + (this.redirectUri == null ? 43 : this.redirectUri.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="responseCode")
        private Integer responseCode;
        @JsonProperty(value="conditions")
        private List<RuleCondition> conditions;
        @JsonProperty(value="redirectUri")
        private RedirectUri redirectUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            this.__explicitlySet__.add("responseCode");
            return this;
        }

        public Builder conditions(List<RuleCondition> conditions) {
            this.conditions = conditions;
            this.__explicitlySet__.add("conditions");
            return this;
        }

        public Builder redirectUri(RedirectUri redirectUri) {
            this.redirectUri = redirectUri;
            this.__explicitlySet__.add("redirectUri");
            return this;
        }

        public RedirectRule build() {
            RedirectRule model = new RedirectRule(this.responseCode, this.conditions, this.redirectUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RedirectRule model) {
            if (model.wasPropertyExplicitlySet("responseCode")) {
                this.responseCode(model.getResponseCode());
            }
            if (model.wasPropertyExplicitlySet("conditions")) {
                this.conditions(model.getConditions());
            }
            if (model.wasPropertyExplicitlySet("redirectUri")) {
                this.redirectUri(model.getRedirectUri());
            }
            return this;
        }
    }
}

