/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loadbalancer.model.BackendDetails;
import com.oracle.bmc.loadbalancer.model.HealthCheckerDetails;
import com.oracle.bmc.loadbalancer.model.LBCookieSessionPersistenceConfigurationDetails;
import com.oracle.bmc.loadbalancer.model.SSLConfigurationDetails;
import com.oracle.bmc.loadbalancer.model.SessionPersistenceConfigurationDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendSetDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="policy")
    private final String policy;
    @JsonProperty(value="backends")
    private final List<BackendDetails> backends;
    @JsonProperty(value="healthChecker")
    private final HealthCheckerDetails healthChecker;
    @JsonProperty(value="sslConfiguration")
    private final SSLConfigurationDetails sslConfiguration;
    @JsonProperty(value="sessionPersistenceConfiguration")
    private final SessionPersistenceConfigurationDetails sessionPersistenceConfiguration;
    @JsonProperty(value="lbCookieSessionPersistenceConfiguration")
    private final LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration;

    @Deprecated
    @ConstructorProperties(value={"policy", "backends", "healthChecker", "sslConfiguration", "sessionPersistenceConfiguration", "lbCookieSessionPersistenceConfiguration"})
    public BackendSetDetails(String policy, List<BackendDetails> backends, HealthCheckerDetails healthChecker, SSLConfigurationDetails sslConfiguration, SessionPersistenceConfigurationDetails sessionPersistenceConfiguration, LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration) {
        this.policy = policy;
        this.backends = backends;
        this.healthChecker = healthChecker;
        this.sslConfiguration = sslConfiguration;
        this.sessionPersistenceConfiguration = sessionPersistenceConfiguration;
        this.lbCookieSessionPersistenceConfiguration = lbCookieSessionPersistenceConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPolicy() {
        return this.policy;
    }

    public List<BackendDetails> getBackends() {
        return this.backends;
    }

    public HealthCheckerDetails getHealthChecker() {
        return this.healthChecker;
    }

    public SSLConfigurationDetails getSslConfiguration() {
        return this.sslConfiguration;
    }

    public SessionPersistenceConfigurationDetails getSessionPersistenceConfiguration() {
        return this.sessionPersistenceConfiguration;
    }

    public LBCookieSessionPersistenceConfigurationDetails getLbCookieSessionPersistenceConfiguration() {
        return this.lbCookieSessionPersistenceConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendSetDetails(");
        sb.append("super=").append(super.toString());
        sb.append("policy=").append(String.valueOf(this.policy));
        sb.append(", backends=").append(String.valueOf(this.backends));
        sb.append(", healthChecker=").append(String.valueOf((Object)this.healthChecker));
        sb.append(", sslConfiguration=").append(String.valueOf((Object)this.sslConfiguration));
        sb.append(", sessionPersistenceConfiguration=").append(String.valueOf((Object)this.sessionPersistenceConfiguration));
        sb.append(", lbCookieSessionPersistenceConfiguration=").append(String.valueOf((Object)this.lbCookieSessionPersistenceConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendSetDetails)) {
            return false;
        }
        BackendSetDetails other = (BackendSetDetails)((Object)o);
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.backends, other.backends) && Objects.equals((Object)this.healthChecker, (Object)other.healthChecker) && Objects.equals((Object)this.sslConfiguration, (Object)other.sslConfiguration) && Objects.equals((Object)this.sessionPersistenceConfiguration, (Object)other.sessionPersistenceConfiguration) && Objects.equals((Object)this.lbCookieSessionPersistenceConfiguration, (Object)other.lbCookieSessionPersistenceConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.policy == null ? 43 : this.policy.hashCode());
        result = result * 59 + (this.backends == null ? 43 : this.backends.hashCode());
        result = result * 59 + (this.healthChecker == null ? 43 : this.healthChecker.hashCode());
        result = result * 59 + (this.sslConfiguration == null ? 43 : this.sslConfiguration.hashCode());
        result = result * 59 + (this.sessionPersistenceConfiguration == null ? 43 : this.sessionPersistenceConfiguration.hashCode());
        result = result * 59 + (this.lbCookieSessionPersistenceConfiguration == null ? 43 : this.lbCookieSessionPersistenceConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policy")
        private String policy;
        @JsonProperty(value="backends")
        private List<BackendDetails> backends;
        @JsonProperty(value="healthChecker")
        private HealthCheckerDetails healthChecker;
        @JsonProperty(value="sslConfiguration")
        private SSLConfigurationDetails sslConfiguration;
        @JsonProperty(value="sessionPersistenceConfiguration")
        private SessionPersistenceConfigurationDetails sessionPersistenceConfiguration;
        @JsonProperty(value="lbCookieSessionPersistenceConfiguration")
        private LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policy(String policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Builder backends(List<BackendDetails> backends) {
            this.backends = backends;
            this.__explicitlySet__.add("backends");
            return this;
        }

        public Builder healthChecker(HealthCheckerDetails healthChecker) {
            this.healthChecker = healthChecker;
            this.__explicitlySet__.add("healthChecker");
            return this;
        }

        public Builder sslConfiguration(SSLConfigurationDetails sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            this.__explicitlySet__.add("sslConfiguration");
            return this;
        }

        public Builder sessionPersistenceConfiguration(SessionPersistenceConfigurationDetails sessionPersistenceConfiguration) {
            this.sessionPersistenceConfiguration = sessionPersistenceConfiguration;
            this.__explicitlySet__.add("sessionPersistenceConfiguration");
            return this;
        }

        public Builder lbCookieSessionPersistenceConfiguration(LBCookieSessionPersistenceConfigurationDetails lbCookieSessionPersistenceConfiguration) {
            this.lbCookieSessionPersistenceConfiguration = lbCookieSessionPersistenceConfiguration;
            this.__explicitlySet__.add("lbCookieSessionPersistenceConfiguration");
            return this;
        }

        public BackendSetDetails build() {
            BackendSetDetails model = new BackendSetDetails(this.policy, this.backends, this.healthChecker, this.sslConfiguration, this.sessionPersistenceConfiguration, this.lbCookieSessionPersistenceConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackendSetDetails model) {
            if (model.wasPropertyExplicitlySet("policy")) {
                this.policy(model.getPolicy());
            }
            if (model.wasPropertyExplicitlySet("backends")) {
                this.backends(model.getBackends());
            }
            if (model.wasPropertyExplicitlySet("healthChecker")) {
                this.healthChecker(model.getHealthChecker());
            }
            if (model.wasPropertyExplicitlySet("sslConfiguration")) {
                this.sslConfiguration(model.getSslConfiguration());
            }
            if (model.wasPropertyExplicitlySet("sessionPersistenceConfiguration")) {
                this.sessionPersistenceConfiguration(model.getSessionPersistenceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("lbCookieSessionPersistenceConfiguration")) {
                this.lbCookieSessionPersistenceConfiguration(model.getLbCookieSessionPersistenceConfiguration());
            }
            return this;
        }
    }
}

