/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loadbalancer.model.HealthCheckResult;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackendHealth
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="healthCheckResults")
    private final List<HealthCheckResult> healthCheckResults;

    @Deprecated
    @ConstructorProperties(value={"status", "healthCheckResults"})
    public BackendHealth(Status status, List<HealthCheckResult> healthCheckResults) {
        this.status = status;
        this.healthCheckResults = healthCheckResults;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public List<HealthCheckResult> getHealthCheckResults() {
        return this.healthCheckResults;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackendHealth(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", healthCheckResults=").append(String.valueOf(this.healthCheckResults));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendHealth)) {
            return false;
        }
        BackendHealth other = (BackendHealth)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.healthCheckResults, other.healthCheckResults) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.healthCheckResults == null ? 43 : this.healthCheckResults.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Ok("OK"),
        Warning("WARNING"),
        Critical("CRITICAL"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="healthCheckResults")
        private List<HealthCheckResult> healthCheckResults;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder healthCheckResults(List<HealthCheckResult> healthCheckResults) {
            this.healthCheckResults = healthCheckResults;
            this.__explicitlySet__.add("healthCheckResults");
            return this;
        }

        public BackendHealth build() {
            BackendHealth model = new BackendHealth(this.status, this.healthCheckResults);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackendHealth model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("healthCheckResults")) {
                this.healthCheckResults(model.getHealthCheckResults());
            }
            return this;
        }
    }
}

