/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetQuotaRequest
extends BmcRequest<Void> {
    private String quotaId;
    private String opcRequestId;

    public String getQuotaId() {
        return this.quotaId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().quotaId(this.quotaId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",quotaId=").append(String.valueOf(this.quotaId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetQuotaRequest)) {
            return false;
        }
        GetQuotaRequest other = (GetQuotaRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.quotaId, other.quotaId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.quotaId == null ? 43 : this.quotaId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetQuotaRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String quotaId = null;
        private String opcRequestId = null;

        public Builder quotaId(String quotaId) {
            this.quotaId = quotaId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetQuotaRequest o) {
            this.quotaId(o.getQuotaId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetQuotaRequest build() {
            GetQuotaRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetQuotaRequest buildWithoutInvocationCallback() {
            GetQuotaRequest request = new GetQuotaRequest();
            request.quotaId = this.quotaId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

