/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceAvailability
extends ExplicitlySetBmcModel {
    @JsonProperty(value="used")
    private final Long used;
    @JsonProperty(value="available")
    private final Long available;
    @JsonProperty(value="fractionalUsage")
    private final BigDecimal fractionalUsage;
    @JsonProperty(value="fractionalAvailability")
    private final BigDecimal fractionalAvailability;
    @JsonProperty(value="effectiveQuotaValue")
    private final BigDecimal effectiveQuotaValue;

    @Deprecated
    @ConstructorProperties(value={"used", "available", "fractionalUsage", "fractionalAvailability", "effectiveQuotaValue"})
    public ResourceAvailability(Long used, Long available, BigDecimal fractionalUsage, BigDecimal fractionalAvailability, BigDecimal effectiveQuotaValue) {
        this.used = used;
        this.available = available;
        this.fractionalUsage = fractionalUsage;
        this.fractionalAvailability = fractionalAvailability;
        this.effectiveQuotaValue = effectiveQuotaValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getUsed() {
        return this.used;
    }

    public Long getAvailable() {
        return this.available;
    }

    public BigDecimal getFractionalUsage() {
        return this.fractionalUsage;
    }

    public BigDecimal getFractionalAvailability() {
        return this.fractionalAvailability;
    }

    public BigDecimal getEffectiveQuotaValue() {
        return this.effectiveQuotaValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceAvailability(");
        sb.append("super=").append(super.toString());
        sb.append("used=").append(String.valueOf(this.used));
        sb.append(", available=").append(String.valueOf(this.available));
        sb.append(", fractionalUsage=").append(String.valueOf(this.fractionalUsage));
        sb.append(", fractionalAvailability=").append(String.valueOf(this.fractionalAvailability));
        sb.append(", effectiveQuotaValue=").append(String.valueOf(this.effectiveQuotaValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceAvailability)) {
            return false;
        }
        ResourceAvailability other = (ResourceAvailability)((Object)o);
        return Objects.equals(this.used, other.used) && Objects.equals(this.available, other.available) && Objects.equals(this.fractionalUsage, other.fractionalUsage) && Objects.equals(this.fractionalAvailability, other.fractionalAvailability) && Objects.equals(this.effectiveQuotaValue, other.effectiveQuotaValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.used == null ? 43 : this.used.hashCode());
        result = result * 59 + (this.available == null ? 43 : this.available.hashCode());
        result = result * 59 + (this.fractionalUsage == null ? 43 : this.fractionalUsage.hashCode());
        result = result * 59 + (this.fractionalAvailability == null ? 43 : this.fractionalAvailability.hashCode());
        result = result * 59 + (this.effectiveQuotaValue == null ? 43 : this.effectiveQuotaValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="used")
        private Long used;
        @JsonProperty(value="available")
        private Long available;
        @JsonProperty(value="fractionalUsage")
        private BigDecimal fractionalUsage;
        @JsonProperty(value="fractionalAvailability")
        private BigDecimal fractionalAvailability;
        @JsonProperty(value="effectiveQuotaValue")
        private BigDecimal effectiveQuotaValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder used(Long used) {
            this.used = used;
            this.__explicitlySet__.add("used");
            return this;
        }

        public Builder available(Long available) {
            this.available = available;
            this.__explicitlySet__.add("available");
            return this;
        }

        public Builder fractionalUsage(BigDecimal fractionalUsage) {
            this.fractionalUsage = fractionalUsage;
            this.__explicitlySet__.add("fractionalUsage");
            return this;
        }

        public Builder fractionalAvailability(BigDecimal fractionalAvailability) {
            this.fractionalAvailability = fractionalAvailability;
            this.__explicitlySet__.add("fractionalAvailability");
            return this;
        }

        public Builder effectiveQuotaValue(BigDecimal effectiveQuotaValue) {
            this.effectiveQuotaValue = effectiveQuotaValue;
            this.__explicitlySet__.add("effectiveQuotaValue");
            return this;
        }

        public ResourceAvailability build() {
            ResourceAvailability model = new ResourceAvailability(this.used, this.available, this.fractionalUsage, this.fractionalAvailability, this.effectiveQuotaValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceAvailability model) {
            if (model.wasPropertyExplicitlySet("used")) {
                this.used(model.getUsed());
            }
            if (model.wasPropertyExplicitlySet("available")) {
                this.available(model.getAvailable());
            }
            if (model.wasPropertyExplicitlySet("fractionalUsage")) {
                this.fractionalUsage(model.getFractionalUsage());
            }
            if (model.wasPropertyExplicitlySet("fractionalAvailability")) {
                this.fractionalAvailability(model.getFractionalAvailability());
            }
            if (model.wasPropertyExplicitlySet("effectiveQuotaValue")) {
                this.effectiveQuotaValue(model.getEffectiveQuotaValue());
            }
            return this;
        }
    }
}

