/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.limits.Quotas;
import com.oracle.bmc.limits.QuotasAsyncClient;
import com.oracle.bmc.limits.QuotasPaginators;
import com.oracle.bmc.limits.QuotasWaiters;
import com.oracle.bmc.limits.model.Quota;
import com.oracle.bmc.limits.model.QuotaSummary;
import com.oracle.bmc.limits.requests.AddQuotaLockRequest;
import com.oracle.bmc.limits.requests.CreateQuotaRequest;
import com.oracle.bmc.limits.requests.DeleteQuotaRequest;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.requests.RemoveQuotaLockRequest;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.AddQuotaLockResponse;
import com.oracle.bmc.limits.responses.CreateQuotaResponse;
import com.oracle.bmc.limits.responses.DeleteQuotaResponse;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.limits.responses.RemoveQuotaLockResponse;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotasClient
extends BaseSyncClient
implements Quotas {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUOTAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QuotasAsyncClient.class);
    private final QuotasWaiters waiters;
    private final QuotasPaginators paginators;

    private QuotasClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Quotas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new QuotasWaiters(executorService, this);
        this.paginators = new QuotasPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddQuotaLockResponse addQuotaLock(AddQuotaLockRequest request) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddLockDetails(), "addLockDetails is required");
        return (AddQuotaLockResponse)this.clientCall(request, AddQuotaLockResponse::builder).logger(LOG, "addQuotaLock").serviceDetails("Quotas", "AddQuotaLock", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/AddQuotaLock").method(Method.POST).requestBuilder(AddQuotaLockRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendPathParam("actions").appendPathParam("addLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, AddQuotaLockResponse.Builder::quota).handleResponseHeaderString("etag", AddQuotaLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddQuotaLockResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateQuotaResponse createQuota(CreateQuotaRequest request) {
        Objects.requireNonNull(request.getCreateQuotaDetails(), "createQuotaDetails is required");
        return (CreateQuotaResponse)this.clientCall(request, CreateQuotaResponse::builder).logger(LOG, "createQuota").serviceDetails("Quotas", "CreateQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/CreateQuota").method(Method.POST).requestBuilder(CreateQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Quota.class, CreateQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", CreateQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateQuotaResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteQuotaResponse deleteQuota(DeleteQuotaRequest request) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        return (DeleteQuotaResponse)this.clientCall(request, DeleteQuotaResponse::builder).logger(LOG, "deleteQuota").serviceDetails("Quotas", "DeleteQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/DeleteQuota").method(Method.DELETE).requestBuilder(DeleteQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteQuotaResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetQuotaResponse getQuota(GetQuotaRequest request) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        return (GetQuotaResponse)this.clientCall(request, GetQuotaResponse::builder).logger(LOG, "getQuota").serviceDetails("Quotas", "GetQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/GetQuota").method(Method.GET).requestBuilder(GetQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Quota.class, GetQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", GetQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetQuotaResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListQuotasResponse listQuotas(ListQuotasRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListQuotasResponse)this.clientCall(request, ListQuotasResponse::builder).logger(LOG, "listQuotas").serviceDetails("Quotas", "ListQuotas", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/QuotaSummary/ListQuotas").method(Method.GET).requestBuilder(ListQuotasRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(QuotaSummary.class, ListQuotasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListQuotasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListQuotasResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveQuotaLockResponse removeQuotaLock(RemoveQuotaLockRequest request) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveLockDetails(), "removeLockDetails is required");
        return (RemoveQuotaLockResponse)this.clientCall(request, RemoveQuotaLockResponse::builder).logger(LOG, "removeQuotaLock").serviceDetails("Quotas", "RemoveQuotaLock", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/RemoveQuotaLock").method(Method.POST).requestBuilder(RemoveQuotaLockRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendPathParam("actions").appendPathParam("removeLock").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, RemoveQuotaLockResponse.Builder::quota).handleResponseHeaderString("etag", RemoveQuotaLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveQuotaLockResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateQuotaResponse updateQuota(UpdateQuotaRequest request) {
        Validate.notBlank((String)request.getQuotaId(), (String)"quotaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateQuotaDetails(), "updateQuotaDetails is required");
        return (UpdateQuotaResponse)this.clientCall(request, UpdateQuotaResponse::builder).logger(LOG, "updateQuota").serviceDetails("Quotas", "UpdateQuota", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/Quota/UpdateQuota").method(Method.PUT).requestBuilder(UpdateQuotaRequest::builder).basePath("/").appendPathParam("20181025").appendPathParam("quotas").appendPathParam(request.getQuotaId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Quota.class, UpdateQuotaResponse.Builder::quota).handleResponseHeaderString("opc-request-id", UpdateQuotaResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateQuotaResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public QuotasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public QuotasPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QuotasClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QuotasClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QuotasClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QuotasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public QuotasClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QuotasClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

