/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.licensemanager.model.LicenseUnit;
import com.oracle.bmc.licensemanager.model.Product;
import com.oracle.bmc.licensemanager.model.ResourceUnit;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProductLicenseConsumerSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="resourceCompartmentId")
    private final String resourceCompartmentId;
    @JsonProperty(value="resourceCompartmentName")
    private final String resourceCompartmentName;
    @JsonProperty(value="resourceUnitType")
    private final ResourceUnit resourceUnitType;
    @JsonProperty(value="resourceUnitCount")
    private final Double resourceUnitCount;
    @JsonProperty(value="licenseUnitType")
    private final LicenseUnit licenseUnitType;
    @JsonProperty(value="licenseUnitsConsumed")
    private final Double licenseUnitsConsumed;
    @JsonProperty(value="isBaseLicenseAvailable")
    private final Boolean isBaseLicenseAvailable;
    @JsonProperty(value="areAllOptionsAvailable")
    private final Boolean areAllOptionsAvailable;
    @JsonProperty(value="missingProducts")
    private final List<Product> missingProducts;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceName", "productName", "resourceCompartmentId", "resourceCompartmentName", "resourceUnitType", "resourceUnitCount", "licenseUnitType", "licenseUnitsConsumed", "isBaseLicenseAvailable", "areAllOptionsAvailable", "missingProducts"})
    public ProductLicenseConsumerSummary(String resourceId, String resourceName, String productName, String resourceCompartmentId, String resourceCompartmentName, ResourceUnit resourceUnitType, Double resourceUnitCount, LicenseUnit licenseUnitType, Double licenseUnitsConsumed, Boolean isBaseLicenseAvailable, Boolean areAllOptionsAvailable, List<Product> missingProducts) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.productName = productName;
        this.resourceCompartmentId = resourceCompartmentId;
        this.resourceCompartmentName = resourceCompartmentName;
        this.resourceUnitType = resourceUnitType;
        this.resourceUnitCount = resourceUnitCount;
        this.licenseUnitType = licenseUnitType;
        this.licenseUnitsConsumed = licenseUnitsConsumed;
        this.isBaseLicenseAvailable = isBaseLicenseAvailable;
        this.areAllOptionsAvailable = areAllOptionsAvailable;
        this.missingProducts = missingProducts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getResourceCompartmentId() {
        return this.resourceCompartmentId;
    }

    public String getResourceCompartmentName() {
        return this.resourceCompartmentName;
    }

    public ResourceUnit getResourceUnitType() {
        return this.resourceUnitType;
    }

    public Double getResourceUnitCount() {
        return this.resourceUnitCount;
    }

    public LicenseUnit getLicenseUnitType() {
        return this.licenseUnitType;
    }

    public Double getLicenseUnitsConsumed() {
        return this.licenseUnitsConsumed;
    }

    public Boolean getIsBaseLicenseAvailable() {
        return this.isBaseLicenseAvailable;
    }

    public Boolean getAreAllOptionsAvailable() {
        return this.areAllOptionsAvailable;
    }

    public List<Product> getMissingProducts() {
        return this.missingProducts;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductLicenseConsumerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", productName=").append(String.valueOf(this.productName));
        sb.append(", resourceCompartmentId=").append(String.valueOf(this.resourceCompartmentId));
        sb.append(", resourceCompartmentName=").append(String.valueOf(this.resourceCompartmentName));
        sb.append(", resourceUnitType=").append(String.valueOf((Object)this.resourceUnitType));
        sb.append(", resourceUnitCount=").append(String.valueOf(this.resourceUnitCount));
        sb.append(", licenseUnitType=").append(String.valueOf((Object)this.licenseUnitType));
        sb.append(", licenseUnitsConsumed=").append(String.valueOf(this.licenseUnitsConsumed));
        sb.append(", isBaseLicenseAvailable=").append(String.valueOf(this.isBaseLicenseAvailable));
        sb.append(", areAllOptionsAvailable=").append(String.valueOf(this.areAllOptionsAvailable));
        sb.append(", missingProducts=").append(String.valueOf(this.missingProducts));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductLicenseConsumerSummary)) {
            return false;
        }
        ProductLicenseConsumerSummary other = (ProductLicenseConsumerSummary)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.productName, other.productName) && Objects.equals(this.resourceCompartmentId, other.resourceCompartmentId) && Objects.equals(this.resourceCompartmentName, other.resourceCompartmentName) && Objects.equals((Object)this.resourceUnitType, (Object)other.resourceUnitType) && Objects.equals(this.resourceUnitCount, other.resourceUnitCount) && Objects.equals((Object)this.licenseUnitType, (Object)other.licenseUnitType) && Objects.equals(this.licenseUnitsConsumed, other.licenseUnitsConsumed) && Objects.equals(this.isBaseLicenseAvailable, other.isBaseLicenseAvailable) && Objects.equals(this.areAllOptionsAvailable, other.areAllOptionsAvailable) && Objects.equals(this.missingProducts, other.missingProducts) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.productName == null ? 43 : this.productName.hashCode());
        result = result * 59 + (this.resourceCompartmentId == null ? 43 : this.resourceCompartmentId.hashCode());
        result = result * 59 + (this.resourceCompartmentName == null ? 43 : this.resourceCompartmentName.hashCode());
        result = result * 59 + (this.resourceUnitType == null ? 43 : this.resourceUnitType.hashCode());
        result = result * 59 + (this.resourceUnitCount == null ? 43 : this.resourceUnitCount.hashCode());
        result = result * 59 + (this.licenseUnitType == null ? 43 : this.licenseUnitType.hashCode());
        result = result * 59 + (this.licenseUnitsConsumed == null ? 43 : this.licenseUnitsConsumed.hashCode());
        result = result * 59 + (this.isBaseLicenseAvailable == null ? 43 : this.isBaseLicenseAvailable.hashCode());
        result = result * 59 + (this.areAllOptionsAvailable == null ? 43 : this.areAllOptionsAvailable.hashCode());
        result = result * 59 + (this.missingProducts == null ? 43 : this.missingProducts.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="productName")
        private String productName;
        @JsonProperty(value="resourceCompartmentId")
        private String resourceCompartmentId;
        @JsonProperty(value="resourceCompartmentName")
        private String resourceCompartmentName;
        @JsonProperty(value="resourceUnitType")
        private ResourceUnit resourceUnitType;
        @JsonProperty(value="resourceUnitCount")
        private Double resourceUnitCount;
        @JsonProperty(value="licenseUnitType")
        private LicenseUnit licenseUnitType;
        @JsonProperty(value="licenseUnitsConsumed")
        private Double licenseUnitsConsumed;
        @JsonProperty(value="isBaseLicenseAvailable")
        private Boolean isBaseLicenseAvailable;
        @JsonProperty(value="areAllOptionsAvailable")
        private Boolean areAllOptionsAvailable;
        @JsonProperty(value="missingProducts")
        private List<Product> missingProducts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.__explicitlySet__.add("productName");
            return this;
        }

        public Builder resourceCompartmentId(String resourceCompartmentId) {
            this.resourceCompartmentId = resourceCompartmentId;
            this.__explicitlySet__.add("resourceCompartmentId");
            return this;
        }

        public Builder resourceCompartmentName(String resourceCompartmentName) {
            this.resourceCompartmentName = resourceCompartmentName;
            this.__explicitlySet__.add("resourceCompartmentName");
            return this;
        }

        public Builder resourceUnitType(ResourceUnit resourceUnitType) {
            this.resourceUnitType = resourceUnitType;
            this.__explicitlySet__.add("resourceUnitType");
            return this;
        }

        public Builder resourceUnitCount(Double resourceUnitCount) {
            this.resourceUnitCount = resourceUnitCount;
            this.__explicitlySet__.add("resourceUnitCount");
            return this;
        }

        public Builder licenseUnitType(LicenseUnit licenseUnitType) {
            this.licenseUnitType = licenseUnitType;
            this.__explicitlySet__.add("licenseUnitType");
            return this;
        }

        public Builder licenseUnitsConsumed(Double licenseUnitsConsumed) {
            this.licenseUnitsConsumed = licenseUnitsConsumed;
            this.__explicitlySet__.add("licenseUnitsConsumed");
            return this;
        }

        public Builder isBaseLicenseAvailable(Boolean isBaseLicenseAvailable) {
            this.isBaseLicenseAvailable = isBaseLicenseAvailable;
            this.__explicitlySet__.add("isBaseLicenseAvailable");
            return this;
        }

        public Builder areAllOptionsAvailable(Boolean areAllOptionsAvailable) {
            this.areAllOptionsAvailable = areAllOptionsAvailable;
            this.__explicitlySet__.add("areAllOptionsAvailable");
            return this;
        }

        public Builder missingProducts(List<Product> missingProducts) {
            this.missingProducts = missingProducts;
            this.__explicitlySet__.add("missingProducts");
            return this;
        }

        public ProductLicenseConsumerSummary build() {
            ProductLicenseConsumerSummary model = new ProductLicenseConsumerSummary(this.resourceId, this.resourceName, this.productName, this.resourceCompartmentId, this.resourceCompartmentName, this.resourceUnitType, this.resourceUnitCount, this.licenseUnitType, this.licenseUnitsConsumed, this.isBaseLicenseAvailable, this.areAllOptionsAvailable, this.missingProducts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProductLicenseConsumerSummary model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("productName")) {
                this.productName(model.getProductName());
            }
            if (model.wasPropertyExplicitlySet("resourceCompartmentId")) {
                this.resourceCompartmentId(model.getResourceCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceCompartmentName")) {
                this.resourceCompartmentName(model.getResourceCompartmentName());
            }
            if (model.wasPropertyExplicitlySet("resourceUnitType")) {
                this.resourceUnitType(model.getResourceUnitType());
            }
            if (model.wasPropertyExplicitlySet("resourceUnitCount")) {
                this.resourceUnitCount(model.getResourceUnitCount());
            }
            if (model.wasPropertyExplicitlySet("licenseUnitType")) {
                this.licenseUnitType(model.getLicenseUnitType());
            }
            if (model.wasPropertyExplicitlySet("licenseUnitsConsumed")) {
                this.licenseUnitsConsumed(model.getLicenseUnitsConsumed());
            }
            if (model.wasPropertyExplicitlySet("isBaseLicenseAvailable")) {
                this.isBaseLicenseAvailable(model.getIsBaseLicenseAvailable());
            }
            if (model.wasPropertyExplicitlySet("areAllOptionsAvailable")) {
                this.areAllOptionsAvailable(model.getAreAllOptionsAvailable());
            }
            if (model.wasPropertyExplicitlySet("missingProducts")) {
                this.missingProducts(model.getMissingProducts());
            }
            return this;
        }
    }
}

