/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.LibrarySortBy;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class SummarizeLibraryUsageRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String serverInstanceKey;
    private String managedInstanceId;
    private String applicationKey;
    private String libraryKey;
    private String libraryNameContains;
    private String libraryName;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private LibrarySortBy sortBy;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getServerInstanceKey() {
        return this.serverInstanceKey;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getLibraryKey() {
        return this.libraryKey;
    }

    public String getLibraryNameContains() {
        return this.libraryNameContains;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LibrarySortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).serverInstanceKey(this.serverInstanceKey).managedInstanceId(this.managedInstanceId).applicationKey(this.applicationKey).libraryKey(this.libraryKey).libraryNameContains(this.libraryNameContains).libraryName(this.libraryName).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",serverInstanceKey=").append(String.valueOf(this.serverInstanceKey));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",libraryKey=").append(String.valueOf(this.libraryKey));
        sb.append(",libraryNameContains=").append(String.valueOf(this.libraryNameContains));
        sb.append(",libraryName=").append(String.valueOf(this.libraryName));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeLibraryUsageRequest)) {
            return false;
        }
        SummarizeLibraryUsageRequest other = (SummarizeLibraryUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.serverInstanceKey, other.serverInstanceKey) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.libraryKey, other.libraryKey) && Objects.equals(this.libraryNameContains, other.libraryNameContains) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.serverInstanceKey == null ? 43 : this.serverInstanceKey.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.libraryKey == null ? 43 : this.libraryKey.hashCode());
        result = result * 59 + (this.libraryNameContains == null ? 43 : this.libraryNameContains.hashCode());
        result = result * 59 + (this.libraryName == null ? 43 : this.libraryName.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeLibraryUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String serverInstanceKey = null;
        private String managedInstanceId = null;
        private String applicationKey = null;
        private String libraryKey = null;
        private String libraryNameContains = null;
        private String libraryName = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private LibrarySortBy sortBy = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder serverInstanceKey(String serverInstanceKey) {
            this.serverInstanceKey = serverInstanceKey;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder libraryKey(String libraryKey) {
            this.libraryKey = libraryKey;
            return this;
        }

        public Builder libraryNameContains(String libraryNameContains) {
            this.libraryNameContains = libraryNameContains;
            return this;
        }

        public Builder libraryName(String libraryName) {
            this.libraryName = libraryName;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(LibrarySortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeLibraryUsageRequest o) {
            this.fleetId(o.getFleetId());
            this.serverInstanceKey(o.getServerInstanceKey());
            this.managedInstanceId(o.getManagedInstanceId());
            this.applicationKey(o.getApplicationKey());
            this.libraryKey(o.getLibraryKey());
            this.libraryNameContains(o.getLibraryNameContains());
            this.libraryName(o.getLibraryName());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeLibraryUsageRequest build() {
            SummarizeLibraryUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeLibraryUsageRequest buildWithoutInvocationCallback() {
            SummarizeLibraryUsageRequest request = new SummarizeLibraryUsageRequest();
            request.fleetId = this.fleetId;
            request.serverInstanceKey = this.serverInstanceKey;
            request.managedInstanceId = this.managedInstanceId;
            request.applicationKey = this.applicationKey;
            request.libraryKey = this.libraryKey;
            request.libraryNameContains = this.libraryNameContains;
            request.libraryName = this.libraryName;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

