/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteCryptoAnalysisResultRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String cryptoAnalysisResultId;
    private String ifMatch;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getCryptoAnalysisResultId() {
        return this.cryptoAnalysisResultId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).cryptoAnalysisResultId(this.cryptoAnalysisResultId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",cryptoAnalysisResultId=").append(String.valueOf(this.cryptoAnalysisResultId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteCryptoAnalysisResultRequest)) {
            return false;
        }
        DeleteCryptoAnalysisResultRequest other = (DeleteCryptoAnalysisResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.cryptoAnalysisResultId, other.cryptoAnalysisResultId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.cryptoAnalysisResultId == null ? 43 : this.cryptoAnalysisResultId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCryptoAnalysisResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String cryptoAnalysisResultId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder cryptoAnalysisResultId(String cryptoAnalysisResultId) {
            this.cryptoAnalysisResultId = cryptoAnalysisResultId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCryptoAnalysisResultRequest o) {
            this.fleetId(o.getFleetId());
            this.cryptoAnalysisResultId(o.getCryptoAnalysisResultId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCryptoAnalysisResultRequest build() {
            DeleteCryptoAnalysisResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteCryptoAnalysisResultRequest buildWithoutInvocationCallback() {
            DeleteCryptoAnalysisResultRequest request = new DeleteCryptoAnalysisResultRequest();
            request.fleetId = this.fleetId;
            request.cryptoAnalysisResultId = this.cryptoAnalysisResultId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

