/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JfrAttachmentTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="jreKey")
    private final String jreKey;

    @Deprecated
    @ConstructorProperties(value={"managedInstanceId", "applicationKey", "jreKey"})
    public JfrAttachmentTarget(String managedInstanceId, String applicationKey, String jreKey) {
        this.managedInstanceId = managedInstanceId;
        this.applicationKey = applicationKey;
        this.jreKey = jreKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getJreKey() {
        return this.jreKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JfrAttachmentTarget(");
        sb.append("super=").append(super.toString());
        sb.append("managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", jreKey=").append(String.valueOf(this.jreKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JfrAttachmentTarget)) {
            return false;
        }
        JfrAttachmentTarget other = (JfrAttachmentTarget)((Object)o);
        return Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.jreKey, other.jreKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.jreKey == null ? 43 : this.jreKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="jreKey")
        private String jreKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder jreKey(String jreKey) {
            this.jreKey = jreKey;
            this.__explicitlySet__.add("jreKey");
            return this;
        }

        public JfrAttachmentTarget build() {
            JfrAttachmentTarget model = new JfrAttachmentTarget(this.managedInstanceId, this.applicationKey, this.jreKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JfrAttachmentTarget model) {
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("jreKey")) {
                this.jreKey(model.getJreKey());
            }
            return this;
        }
    }
}

