/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.LicenseType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaLicense
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="licenseType")
    private final LicenseType licenseType;
    @JsonProperty(value="licenseUrl")
    private final String licenseUrl;

    @Deprecated
    @ConstructorProperties(value={"displayName", "licenseType", "licenseUrl"})
    public JavaLicense(String displayName, LicenseType licenseType, String licenseUrl) {
        this.displayName = displayName;
        this.licenseType = licenseType;
        this.licenseUrl = licenseUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaLicense(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(", licenseUrl=").append(String.valueOf(this.licenseUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaLicense)) {
            return false;
        }
        JavaLicense other = (JavaLicense)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals(this.licenseUrl, other.licenseUrl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.licenseUrl == null ? 43 : this.licenseUrl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="licenseType")
        private LicenseType licenseType;
        @JsonProperty(value="licenseUrl")
        private String licenseUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            this.__explicitlySet__.add("licenseType");
            return this;
        }

        public Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            this.__explicitlySet__.add("licenseUrl");
            return this;
        }

        public JavaLicense build() {
            JavaLicense model = new JavaLicense(this.displayName, this.licenseType, this.licenseUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaLicense model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("licenseType")) {
                this.licenseType(model.getLicenseType());
            }
            if (model.wasPropertyExplicitlySet("licenseUrl")) {
                this.licenseUrl(model.getLicenseUrl());
            }
            return this;
        }
    }
}

