/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ArtifactContentType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaArtifact
extends ExplicitlySetBmcModel {
    @JsonProperty(value="artifactId")
    private final Long artifactId;
    @JsonProperty(value="artifactDescription")
    private final String artifactDescription;
    @JsonProperty(value="artifactContentType")
    private final ArtifactContentType artifactContentType;
    @JsonProperty(value="approximateFileSizeInBytes")
    private final Long approximateFileSizeInBytes;
    @JsonProperty(value="sha256")
    private final String sha256;

    @Deprecated
    @ConstructorProperties(value={"artifactId", "artifactDescription", "artifactContentType", "approximateFileSizeInBytes", "sha256"})
    public JavaArtifact(Long artifactId, String artifactDescription, ArtifactContentType artifactContentType, Long approximateFileSizeInBytes, String sha256) {
        this.artifactId = artifactId;
        this.artifactDescription = artifactDescription;
        this.artifactContentType = artifactContentType;
        this.approximateFileSizeInBytes = approximateFileSizeInBytes;
        this.sha256 = sha256;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public ArtifactContentType getArtifactContentType() {
        return this.artifactContentType;
    }

    public Long getApproximateFileSizeInBytes() {
        return this.approximateFileSizeInBytes;
    }

    public String getSha256() {
        return this.sha256;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaArtifact(");
        sb.append("super=").append(super.toString());
        sb.append("artifactId=").append(String.valueOf(this.artifactId));
        sb.append(", artifactDescription=").append(String.valueOf(this.artifactDescription));
        sb.append(", artifactContentType=").append(String.valueOf((Object)this.artifactContentType));
        sb.append(", approximateFileSizeInBytes=").append(String.valueOf(this.approximateFileSizeInBytes));
        sb.append(", sha256=").append(String.valueOf(this.sha256));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaArtifact)) {
            return false;
        }
        JavaArtifact other = (JavaArtifact)((Object)o);
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.artifactDescription, other.artifactDescription) && Objects.equals((Object)this.artifactContentType, (Object)other.artifactContentType) && Objects.equals(this.approximateFileSizeInBytes, other.approximateFileSizeInBytes) && Objects.equals(this.sha256, other.sha256) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.artifactId == null ? 43 : this.artifactId.hashCode());
        result = result * 59 + (this.artifactDescription == null ? 43 : this.artifactDescription.hashCode());
        result = result * 59 + (this.artifactContentType == null ? 43 : this.artifactContentType.hashCode());
        result = result * 59 + (this.approximateFileSizeInBytes == null ? 43 : this.approximateFileSizeInBytes.hashCode());
        result = result * 59 + (this.sha256 == null ? 43 : this.sha256.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="artifactId")
        private Long artifactId;
        @JsonProperty(value="artifactDescription")
        private String artifactDescription;
        @JsonProperty(value="artifactContentType")
        private ArtifactContentType artifactContentType;
        @JsonProperty(value="approximateFileSizeInBytes")
        private Long approximateFileSizeInBytes;
        @JsonProperty(value="sha256")
        private String sha256;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder artifactId(Long artifactId) {
            this.artifactId = artifactId;
            this.__explicitlySet__.add("artifactId");
            return this;
        }

        public Builder artifactDescription(String artifactDescription) {
            this.artifactDescription = artifactDescription;
            this.__explicitlySet__.add("artifactDescription");
            return this;
        }

        public Builder artifactContentType(ArtifactContentType artifactContentType) {
            this.artifactContentType = artifactContentType;
            this.__explicitlySet__.add("artifactContentType");
            return this;
        }

        public Builder approximateFileSizeInBytes(Long approximateFileSizeInBytes) {
            this.approximateFileSizeInBytes = approximateFileSizeInBytes;
            this.__explicitlySet__.add("approximateFileSizeInBytes");
            return this;
        }

        public Builder sha256(String sha256) {
            this.sha256 = sha256;
            this.__explicitlySet__.add("sha256");
            return this;
        }

        public JavaArtifact build() {
            JavaArtifact model = new JavaArtifact(this.artifactId, this.artifactDescription, this.artifactContentType, this.approximateFileSizeInBytes, this.sha256);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaArtifact model) {
            if (model.wasPropertyExplicitlySet("artifactId")) {
                this.artifactId(model.getArtifactId());
            }
            if (model.wasPropertyExplicitlySet("artifactDescription")) {
                this.artifactDescription(model.getArtifactDescription());
            }
            if (model.wasPropertyExplicitlySet("artifactContentType")) {
                this.artifactContentType(model.getArtifactContentType());
            }
            if (model.wasPropertyExplicitlySet("approximateFileSizeInBytes")) {
                this.approximateFileSizeInBytes(model.getApproximateFileSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("sha256")) {
                this.sha256(model.getSha256());
            }
            return this;
        }
    }
}

