/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.BlocklistEntry;
import com.oracle.bmc.jms.model.JavaRuntimeId;
import com.oracle.bmc.jms.model.JreSecurityStatus;
import com.oracle.bmc.jms.model.LifecycleState;
import com.oracle.bmc.jms.model.OperatingSystem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstallationSiteSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="installationKey")
    private final String installationKey;
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="jre")
    private final JavaRuntimeId jre;
    @JsonProperty(value="securityStatus")
    private final JreSecurityStatus securityStatus;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="operatingSystem")
    private final OperatingSystem operatingSystem;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;
    @JsonProperty(value="blocklist")
    private final List<BlocklistEntry> blocklist;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"installationKey", "managedInstanceId", "jre", "securityStatus", "path", "operatingSystem", "approximateApplicationCount", "timeLastSeen", "blocklist", "lifecycleState"})
    public InstallationSiteSummary(String installationKey, String managedInstanceId, JavaRuntimeId jre, JreSecurityStatus securityStatus, String path, OperatingSystem operatingSystem, Integer approximateApplicationCount, Date timeLastSeen, List<BlocklistEntry> blocklist, LifecycleState lifecycleState) {
        this.installationKey = installationKey;
        this.managedInstanceId = managedInstanceId;
        this.jre = jre;
        this.securityStatus = securityStatus;
        this.path = path;
        this.operatingSystem = operatingSystem;
        this.approximateApplicationCount = approximateApplicationCount;
        this.timeLastSeen = timeLastSeen;
        this.blocklist = blocklist;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstallationKey() {
        return this.installationKey;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public JavaRuntimeId getJre() {
        return this.jre;
    }

    public JreSecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public String getPath() {
        return this.path;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public List<BlocklistEntry> getBlocklist() {
        return this.blocklist;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstallationSiteSummary(");
        sb.append("super=").append(super.toString());
        sb.append("installationKey=").append(String.valueOf(this.installationKey));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", jre=").append(String.valueOf((Object)this.jre));
        sb.append(", securityStatus=").append(String.valueOf((Object)this.securityStatus));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", operatingSystem=").append(String.valueOf((Object)this.operatingSystem));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(", blocklist=").append(String.valueOf(this.blocklist));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallationSiteSummary)) {
            return false;
        }
        InstallationSiteSummary other = (InstallationSiteSummary)((Object)o);
        return Objects.equals(this.installationKey, other.installationKey) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals((Object)this.jre, (Object)other.jre) && Objects.equals((Object)this.securityStatus, (Object)other.securityStatus) && Objects.equals(this.path, other.path) && Objects.equals((Object)this.operatingSystem, (Object)other.operatingSystem) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && Objects.equals(this.blocklist, other.blocklist) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.installationKey == null ? 43 : this.installationKey.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.jre == null ? 43 : this.jre.hashCode());
        result = result * 59 + (this.securityStatus == null ? 43 : this.securityStatus.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + (this.blocklist == null ? 43 : this.blocklist.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="installationKey")
        private String installationKey;
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="jre")
        private JavaRuntimeId jre;
        @JsonProperty(value="securityStatus")
        private JreSecurityStatus securityStatus;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonProperty(value="blocklist")
        private List<BlocklistEntry> blocklist;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder installationKey(String installationKey) {
            this.installationKey = installationKey;
            this.__explicitlySet__.add("installationKey");
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder jre(JavaRuntimeId jre) {
            this.jre = jre;
            this.__explicitlySet__.add("jre");
            return this;
        }

        public Builder securityStatus(JreSecurityStatus securityStatus) {
            this.securityStatus = securityStatus;
            this.__explicitlySet__.add("securityStatus");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public Builder blocklist(List<BlocklistEntry> blocklist) {
            this.blocklist = blocklist;
            this.__explicitlySet__.add("blocklist");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public InstallationSiteSummary build() {
            InstallationSiteSummary model = new InstallationSiteSummary(this.installationKey, this.managedInstanceId, this.jre, this.securityStatus, this.path, this.operatingSystem, this.approximateApplicationCount, this.timeLastSeen, this.blocklist, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstallationSiteSummary model) {
            if (model.wasPropertyExplicitlySet("installationKey")) {
                this.installationKey(model.getInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("jre")) {
                this.jre(model.getJre());
            }
            if (model.wasPropertyExplicitlySet("securityStatus")) {
                this.securityStatus(model.getSecurityStatus());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            if (model.wasPropertyExplicitlySet("blocklist")) {
                this.blocklist(model.getBlocklist());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

