/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.BlocklistEntry;
import com.oracle.bmc.jms.model.JavaRuntimeId;
import com.oracle.bmc.jms.model.LifecycleState;
import com.oracle.bmc.jms.model.ManagedInstanceType;
import com.oracle.bmc.jms.model.OperatingSystem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstallationSite
extends ExplicitlySetBmcModel {
    @JsonProperty(value="installationKey")
    private final String installationKey;
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="jre")
    private final JavaRuntimeId jre;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="operatingSystem")
    private final OperatingSystem operatingSystem;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;
    @JsonProperty(value="blocklist")
    private final List<BlocklistEntry> blocklist;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="managedInstanceType")
    private final ManagedInstanceType managedInstanceType;
    @JsonProperty(value="hostname")
    private final String hostname;

    @Deprecated
    @ConstructorProperties(value={"installationKey", "managedInstanceId", "jre", "path", "operatingSystem", "approximateApplicationCount", "timeLastSeen", "blocklist", "lifecycleState", "managedInstanceType", "hostname"})
    public InstallationSite(String installationKey, String managedInstanceId, JavaRuntimeId jre, String path, OperatingSystem operatingSystem, Integer approximateApplicationCount, Date timeLastSeen, List<BlocklistEntry> blocklist, LifecycleState lifecycleState, ManagedInstanceType managedInstanceType, String hostname) {
        this.installationKey = installationKey;
        this.managedInstanceId = managedInstanceId;
        this.jre = jre;
        this.path = path;
        this.operatingSystem = operatingSystem;
        this.approximateApplicationCount = approximateApplicationCount;
        this.timeLastSeen = timeLastSeen;
        this.blocklist = blocklist;
        this.lifecycleState = lifecycleState;
        this.managedInstanceType = managedInstanceType;
        this.hostname = hostname;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstallationKey() {
        return this.installationKey;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public JavaRuntimeId getJre() {
        return this.jre;
    }

    public String getPath() {
        return this.path;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public List<BlocklistEntry> getBlocklist() {
        return this.blocklist;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ManagedInstanceType getManagedInstanceType() {
        return this.managedInstanceType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstallationSite(");
        sb.append("super=").append(super.toString());
        sb.append("installationKey=").append(String.valueOf(this.installationKey));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", jre=").append(String.valueOf((Object)this.jre));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", operatingSystem=").append(String.valueOf((Object)this.operatingSystem));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(", blocklist=").append(String.valueOf(this.blocklist));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", managedInstanceType=").append(String.valueOf((Object)this.managedInstanceType));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallationSite)) {
            return false;
        }
        InstallationSite other = (InstallationSite)((Object)o);
        return Objects.equals(this.installationKey, other.installationKey) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals((Object)this.jre, (Object)other.jre) && Objects.equals(this.path, other.path) && Objects.equals((Object)this.operatingSystem, (Object)other.operatingSystem) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && Objects.equals(this.blocklist, other.blocklist) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.managedInstanceType, (Object)other.managedInstanceType) && Objects.equals(this.hostname, other.hostname) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.installationKey == null ? 43 : this.installationKey.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.jre == null ? 43 : this.jre.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + (this.blocklist == null ? 43 : this.blocklist.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.managedInstanceType == null ? 43 : this.managedInstanceType.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="installationKey")
        private String installationKey;
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="jre")
        private JavaRuntimeId jre;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonProperty(value="blocklist")
        private List<BlocklistEntry> blocklist;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="managedInstanceType")
        private ManagedInstanceType managedInstanceType;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder installationKey(String installationKey) {
            this.installationKey = installationKey;
            this.__explicitlySet__.add("installationKey");
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder jre(JavaRuntimeId jre) {
            this.jre = jre;
            this.__explicitlySet__.add("jre");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public Builder blocklist(List<BlocklistEntry> blocklist) {
            this.blocklist = blocklist;
            this.__explicitlySet__.add("blocklist");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder managedInstanceType(ManagedInstanceType managedInstanceType) {
            this.managedInstanceType = managedInstanceType;
            this.__explicitlySet__.add("managedInstanceType");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public InstallationSite build() {
            InstallationSite model = new InstallationSite(this.installationKey, this.managedInstanceId, this.jre, this.path, this.operatingSystem, this.approximateApplicationCount, this.timeLastSeen, this.blocklist, this.lifecycleState, this.managedInstanceType, this.hostname);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstallationSite model) {
            if (model.wasPropertyExplicitlySet("installationKey")) {
                this.installationKey(model.getInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("jre")) {
                this.jre(model.getJre());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            if (model.wasPropertyExplicitlySet("blocklist")) {
                this.blocklist(model.getBlocklist());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceType")) {
                this.managedInstanceType(model.getManagedInstanceType());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            return this;
        }
    }
}

